<?php
/**
 * پردازش دستور پنل ادمین (/panel)
 * 
 * @param int $chatId شناسه چت
 */
function handleAdminPanel($chatId) {
    // ایجاد دکمه‌های پنل ادمین
    $keyboard = [
        [
            ['text' => '📊 آمار ربات', 'callback_data' => 'admin_stats']
        ],
        [
            ['text' => '📝 تنظیم متن استارت', 'callback_data' => 'admin_setstart'],
            ['text' => '🔘 مدیریت دکمه‌ها', 'callback_data' => 'admin_buttons']
        ],
        [
            ['text' => '📢 ارسال همگانی', 'callback_data' => 'admin_broadcast'],
            ['text' => '↪️ فوروارد همگانی', 'callback_data' => 'admin_forward']
        ],
        [
            ['text' => '➕ افزودن ادمین', 'callback_data' => 'admin_addadmin'],
            ['text' => '➖ حذف ادمین', 'callback_data' => 'admin_deladmin']
        ],
        [
            ['text' => '➕ افزودن کانال', 'callback_data' => 'admin_addchannel'],
            ['text' => '➖ حذف کانال', 'callback_data' => 'admin_delchannel']
        ],
        [
            ['text' => '📋 لیست ادمین‌ها', 'callback_data' => 'admin_listadmins'],
            ['text' => '📋 لیست کانال‌ها', 'callback_data' => 'admin_listchannels']
        ],
        [
            ['text' => '👥 لیست کاربران', 'callback_data' => 'admin_listusers']
        ]
    ];
    
    $message = "🔰 <b>پنل مدیریت ربات</b>\n\n";
    $message .= "👨‍💻 به پنل مدیریت ربات خوش آمدید.\n";
    $message .= "🔸 لطفاً یکی از گزینه‌های زیر را انتخاب کنید:";
    
    sendMessage($chatId, $message, ['inline_keyboard' => $keyboard]);
}