# 🎉 ویژگی‌های جدید نسخه 2.0

## 1️⃣ سیستم چند زبانه (Multi-Language)

### قابلیت‌ها:
- ✅ پشتیبانی از 4 زبان: فارسی، انگلیسی، عربی، ترکی
- ✅ تشخیص خودکار زبان از متن
- ✅ تغییر زبان توسط کاربر
- ✅ ذخیره زبان کاربر در دیتابیس
- ✅ ترجمه خودکار تمام پیام‌ها

### نحوه استفاده:

#### در کد:
```php
// استفاده از تابع __()
echo __('welcome.title');
echo __('messages.user_banned', ['name' => 'علی']);

// یا استفاده مستقیم
$lang = Language::getInstance();
echo $lang->get('welcome.message', ['name' => $userName]);
```

#### برای کاربران:
```
/language - تغییر زبان
```

### افزودن زبان جدید:

1. فایل جدید در `languages/` بسازید (مثلاً `ur.php` برای اردو)
2. محتوای فایل:
```php
<?php
return [
    'welcome' => [
        'title' => 'خوش آمدید',
        // ...
    ]
];
```

3. زبان را به لیست اضافه کنید:
```php
// در Language.php
private array $availableLanguages = ['fa', 'en', 'ar', 'tr', 'ur'];
```

---

## 2️⃣ هوش مصنوعی با Gemini

### قابلیت‌ها:
- ✅ چت هوشمند با AI
- ✅ تحلیل احساسات (Sentiment Analysis)
- ✅ تشخیص اسپم
- ✅ خلاصه‌سازی متن
- ✅ ترجمه هوشمند
- ✅ پاسخ به سوالات
- ✅ تولید محتوای خلاق
- ✅ حافظه گفتگو (تا 10 پیام)

### تنظیمات:

1. API Key دریافت کنید:
   - به https://makersuite.google.com/app/apikey بروید
   - API Key بسازید
   - در `config.php` قرار دهید:

```php
define('GEMINI_API_KEY', 'YOUR_API_KEY_HERE');
define('AI_ENABLED', true);
```

### نحوه استفاده:

#### در پیوی:
```
/ai - منوی هوش مصنوعی
یا مستقیم پیام بفرستید، ربات پاسخ میده!
```

#### در گروه:
```
ai سلام چطوری؟
@BotUsername سلام
```

#### در کد:
```php
$ai = GeminiAI::getInstance();

// چت ساده
$response = $ai->chat("سلام، چطوری؟");

// با حافظه گفتگو
$response = $ai->chat("سلام", $userId);

// تحلیل احساسات
$sentiment = $ai->analyzeSentiment("این عالی بود!");
// ['sentiment' => 'positive', 'emoji' => '😊']

// تشخیص اسپم
$isSpam = $ai->detectSpam("کلیک کنید و برنده شوید!");

// خلاصه‌سازی
$summary = $ai->summarize($longText, 100);

// ترجمه
$translated = $ai->translate("Hello", 'fa');

// پاک کردن تاریخچه
$ai->clearHistory($userId);
```

### مدل‌های موجود:
- `gemini-pro` - متن (پیش‌فرض)
- `gemini-pro-vision` - متن + تصویر

```php
$ai->setModel('gemini-pro-vision');
```

---

## 3️⃣ سیستم پلاگین

### قابلیت‌ها:
- ✅ افزودن قابلیت بدون تغییر کد اصلی
- ✅ فعال/غیرفعال کردن آسان
- ✅ تنظیمات جداگانه برای هر پلاگین
- ✅ Event System قدرتمند
- ✅ مدیریت از پنل ادمین

### پلاگین‌های پیش‌فرض:

#### 1. AIAssistantPlugin
- پاسخ هوشمند با AI
- تحلیل احساسات
- خلاصه‌سازی و ترجمه

#### 2. WelcomePlugin
- خوشامدگویی به اعضای جدید
- پیام سفارشی
- متغیرهای داینامیک

### ساخت پلاگین جدید:

1. فایل جدید در `plugins/` بسازید:

```php
<?php
// plugins/MyPlugin.php

class MyPlugin extends BasePlugin {
    protected string $name = 'MyPlugin';
    protected string $version = '1.0.0';
    protected string $description = 'توضیحات پلاگین';
    protected string $author = 'نام شما';
    
    public function onEnable(): void {
        // وقتی پلاگین فعال میشه
    }
    
    public function onDisable(): void {
        // وقتی پلاگین غیرفعال میشه
    }
    
    public function onMessage(array $data): void {
        // وقتی پیام میاد
        $chatId = $data['chat_id'];
        $text = $data['text'];
        
        // کد شما
    }
    
    public function onNewMember(array $data): void {
        // وقتی عضو جدید میاد
        $userId = $data['user_id'];
        
        // کد شما
    }
    
    public function onCommand(array $data): void {
        // وقتی دستور میاد
        $command = $data['command'];
        
        // کد شما
    }
}
```

2. پلاگین خودکار شناسایی میشه!

### Event های موجود:

- `onMessage` - دریافت پیام
- `onCommand` - دریافت دستور
- `onNewMember` - عضو جدید
- `onLeftMember` - خروج عضو
- `onEdit` - ویرایش پیام
- `onCallback` - کلیک دکمه
- `onPhoto` - دریافت عکس
- `onVideo` - دریافت فیلم
- `onVoice` - دریافت ویس
- `onDocument` - دریافت فایل

### مدیریت پلاگین‌ها:

#### از کد:
```php
$pm = PluginManager::getInstance();

// فعال کردن
$pm->enablePlugin('MyPlugin');

// غیرفعال کردن
$pm->disablePlugin('MyPlugin');

// چک کردن
if ($pm->isEnabled('MyPlugin')) {
    // ...
}

// دریافت پلاگین
$plugin = $pm->getPlugin('MyPlugin');

// تنظیمات
$config = $pm->getPluginConfig('MyPlugin');
$pm->setPluginConfig('MyPlugin', ['key' => 'value']);
```

#### از ربات:
```
/plugins - لیست پلاگین‌ها (فقط ادمین)
```

### تنظیمات پلاگین:

```php
// در پلاگین
$config = $this->getConfig();
$value = $config['key'] ?? 'default';

$this->setConfig(['key' => 'new_value']);
```

---

## 📊 مقایسه قبل و بعد

| ویژگی | قبل | بعد |
|-------|-----|-----|
| **زبان‌ها** | فقط فارسی | 4 زبان |
| **AI** | ❌ | ✅ Gemini |
| **پلاگین** | ❌ | ✅ کامل |
| **توسعه** | سخت | آسان |
| **انعطاف** | کم | زیاد |

---

## 🚀 مثال‌های کاربردی

### 1. ربات پشتیبانی با AI:
```php
// در گروه پشتیبانی
if (stripos($text, 'سوال') !== false) {
    $ai = GeminiAI::getInstance();
    $answer = $ai->answer($text);
    $telegram->sendMessage($chatId, $answer);
}
```

### 2. تحلیل نظرات:
```php
$ai = GeminiAI::getInstance();
$sentiment = $ai->analyzeSentiment($userComment);

if ($sentiment['sentiment'] === 'negative') {
    // اعلان به مدیر
    $telegram->sendMessage($adminId, "نظر منفی: {$userComment}");
}
```

### 3. خلاصه گفتگوی روز:
```php
$messages = getMessagesOfDay();
$allText = implode("\n", $messages);

$ai = GeminiAI::getInstance();
$summary = $ai->summarize($allText, 200);

$telegram->sendMessage($chatId, "📝 خلاصه امروز:\n{$summary}");
```

### 4. پلاگین مسابقه:
```php
class QuizPlugin extends BasePlugin {
    public function onCommand(array $data): void {
        if ($data['command'] === 'quiz') {
            $ai = GeminiAI::getInstance();
            $question = $ai->generate("یک سوال چند گزینه‌ای بساز");
            
            $this->telegram->sendMessage(
                $data['chat_id'],
                $question
            );
        }
    }
}
```

---

## 🔧 تنظیمات پیشرفته

### کش AI:
```php
// تنظیم مدت زمان کش (ثانیه)
define('AI_CACHE_TIME', 3600); // 1 ساعت
```

### محدودیت استفاده:
```php
// تعداد درخواست در روز
define('AI_DAILY_LIMIT', 100);
```

### زبان پیش‌فرض:
```php
define('DEFAULT_LANGUAGE', 'fa');
```

---

## 📝 نکات مهم

### امنیت:
- ✅ API Key را محرمانه نگه دارید
- ✅ Rate Limiting فعال کنید
- ✅ ورودی کاربران را فیلتر کنید

### عملکرد:
- ✅ از کش استفاده کنید
- ✅ تاریخچه گفتگو را محدود کنید
- ✅ پلاگین‌های غیرضروری را غیرفعال کنید

### هزینه:
- ⚠️ Gemini API رایگان محدودیت دارد
- ⚠️ برای استفاده سنگین، پلن پولی بگیرید

---

## 🆘 عیب‌یابی

### AI پاسخ نمیده:
1. API Key را چک کنید
2. اتصال اینترنت سرور را بررسی کنید
3. لاگ `ai_errors_*.log` را ببینید

### پلاگین کار نمیکنه:
1. نام کلاس باید با نام فایل یکی باشه
2. حتماً از `BasePlugin` ارث‌بری کنید
3. لاگ `plugin_errors_*.log` را ببینید

### زبان تغییر نمیکنه:
1. جدول `members` باید ستون `language` داشته باشه
2. فایل زبان در `languages/` موجود باشه

---

## 📞 پشتیبانی

سوال دارید؟
- 📢 کانال: @YourChannel
- 💬 گروه: https://t.me/joinchat/XXXXX

---

**نسخه:** 2.0  
**تاریخ:** 1404/08/05  
**توسعه‌دهنده:** Kiro AI Assistant
