# راهنمای رفع مشکل ربات v2

## مراحل تست و رفع مشکل

### 1. تست سینتکس PHP

اگر PHP روی سیستم محلی دارید:
```bash
php -l bot-v2/index.php
php -l bot-v2/Bot.php
php -l bot-v2/Database.php
php -l bot-v2/Telegram.php
```

### 2. تست اتصال دیتابیس

فایل `test.php` رو از طریق مرورگر باز کنید:
```
https://yourdomain.com/bot-v2/test.php
```

این فایل تمام کلاس‌ها رو لود میکنه و مشکلات رو نشون میده.

### 3. چک کردن تنظیمات

در فایل `config.php` این موارد رو چک کنید:

```php
// توکن ربات
define('BOT_TOKEN', 'YOUR_BOT_TOKEN');

// اطلاعات دیتابیس
define('DB_HOST', 'localhost');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_pass');
define('DB_NAME', 'your_db_name');

// آیدی ادمین‌ها
define('ADMIN_IDS', [123456789]); // آیدی عددی خودتون
```

### 4. تست Webhook

برای تست webhook از این URL استفاده کنید:
```
https://api.telegram.org/bot<YOUR_BOT_TOKEN>/getWebhookInfo
```

باید چیزی شبیه این ببینید:
```json
{
  "ok": true,
  "result": {
    "url": "https://yourdomain.com/bot-v2/index.php",
    "has_custom_certificate": false,
    "pending_update_count": 0
  }
}
```

### 5. ست کردن Webhook

اگر webhook ست نشده، از این URL استفاده کنید:
```
https://api.telegram.org/bot<YOUR_BOT_TOKEN>/setWebhook?url=https://yourdomain.com/bot-v2/index.php
```

### 6. چک کردن لاگ‌های خطا

لاگ‌های PHP رو چک کنید:
- در cPanel: Error Log
- در سرور: `/var/log/apache2/error.log` یا `/var/log/nginx/error.log`

لاگ‌های ربات در این مسیرها ذخیره میشن:
- `bot-v2/logs/db_errors_YYYY-MM-DD.log`
- `bot-v2/logs/telegram_errors_YYYY-MM-DD.log`
- `bot-v2/logs/ai_errors_YYYY-MM-DD.log`
- `bot-v2/logs/plugin_errors_YYYY-MM-DD.log`

### 7. مشکلات رایج

#### مشکل 1: ربات پاسخ نمیده
**علت‌های احتمالی:**
- Webhook اشتباه ست شده
- توکن ربات اشتباه است
- فایل index.php در دسترس نیست (403/404)
- خطای PHP که ربات رو متوقف کرده

**راه‌حل:**
1. getWebhookInfo رو چک کنید
2. test.php رو اجرا کنید
3. لاگ‌های خطا رو بررسی کنید

#### مشکل 2: خطای دیتابیس
**علت‌های احتمالی:**
- اطلاعات دیتابیس اشتباه است
- دیتابیس وجود ندارد
- کاربر دسترسی ندارد

**راه‌حل:**
1. اطلاعات دیتابیس در config.php رو چک کنید
2. از phpMyAdmin یا MySQL client اتصال رو تست کنید
3. مطمئن شوید کاربر دسترسی CREATE TABLE داره

#### مشکل 3: خطای 500
**علت‌های احتمالی:**
- خطای سینتکس PHP
- کلاس یا فایل پیدا نمیشه
- مشکل در require_once

**راه‌حل:**
1. لاگ‌های PHP رو چک کنید
2. مطمئن شوید تمام فایل‌ها آپلود شدن
3. مجوزهای فایل‌ها رو چک کنید (644 برای فایل‌ها، 755 برای پوشه‌ها)

#### مشکل 4: پوشه‌ها ساخته نمیشن
**علت:**
- مجوز نوشتن روی سرور نیست

**راه‌حل:**
```bash
chmod 755 bot-v2/data
chmod 755 bot-v2/logs
chmod 755 bot-v2/cache
```

یا از cPanel File Manager این پوشه‌ها رو دستی بسازید.

### 8. تست دستی

برای تست دستی، یه فایل `manual_test.php` بسازید:

```php
<?php
require_once 'config.php';
require_once 'Database.php';
require_once 'Telegram.php';

$telegram = Telegram::getInstance();

// تست ارسال پیام
$result = $telegram->sendMessage(
    YOUR_CHAT_ID, // آیدی عددی خودتون
    "تست ربات - " . date('Y-m-d H:i:s')
);

var_dump($result);
```

سپس از مرورگر باز کنید:
```
https://yourdomain.com/bot-v2/manual_test.php
```

### 9. چک کردن نسخه PHP

ربات نیاز به PHP 7.4 یا بالاتر داره. برای چک کردن:

```php
<?php
echo PHP_VERSION;
```

### 10. فعال کردن Debug Mode

در `config.php`:
```php
define('DEBUG_MODE', true);
```

این کار خطاها رو نمایش میده.

## مراحل نصب صحیح

1. ✅ آپلود تمام فایل‌های bot-v2
2. ✅ ویرایش config.php (توکن، دیتابیس، ادمین)
3. ✅ ساخت دیتابیس MySQL
4. ✅ اجرای test.php از مرورگر
5. ✅ ست کردن webhook
6. ✅ تست ربات با دستور /start

## دستورات مفید

### حذف webhook
```
https://api.telegram.org/bot<TOKEN>/deleteWebhook
```

### دریافت اطلاعات ربات
```
https://api.telegram.org/bot<TOKEN>/getMe
```

### دریافت آپدیت‌های pending
```
https://api.telegram.org/bot<TOKEN>/getUpdates
```

## پشتیبانی

اگر مشکل حل نشد:
1. خروجی test.php رو بررسی کنید
2. لاگ‌های خطا رو چک کنید
3. getWebhookInfo رو بررسی کنید
4. مطمئن شوید PHP 7.4+ دارید
5. مطمئن شوید extension های mysqli و curl فعال هستند

## نکات امنیتی

1. ⚠️ فایل test.php رو بعد از تست حذف کنید
2. ⚠️ DEBUG_MODE رو در production خاموش کنید
3. ⚠️ از HTTPS برای webhook استفاده کنید
4. ⚠️ توکن ربات رو محرمانه نگه دارید
