<?php
/**
 * دیباگ استوری اینستاگرام
 * این فایل پاسخ دقیق API را نمایش می‌دهد
 */

require_once 'config.php';

$username = isset($_GET['username']) ? $_GET['username'] : 'sepiicarr';

// فراخوانی API
$apiParams = [
    'apikey' => INSTAGRAM_API_KEY,
    'type' => 'story',
    'username' => $username
];

$url = INSTAGRAM_API_URL . '?' . http_build_query($apiParams);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$result = json_decode($response, true);

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>Debug استوری - <?php echo $username; ?></title>
    <style>
        body { font-family: Tahoma; padding: 20px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 10px; max-width: 1200px; margin: 0 auto; }
        h1 { color: #333; border-bottom: 3px solid #4CAF50; padding-bottom: 10px; }
        .section { background: #f9f9f9; padding: 20px; margin: 20px 0; border-radius: 8px; }
        pre { background: white; padding: 15px; border-left: 4px solid #4CAF50; overflow-x: auto; direction: ltr; text-align: left; }
        .info { background: #e3f2fd; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .success { color: #4CAF50; }
        .error { color: #f44336; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        table th, table td { padding: 12px; border: 1px solid #ddd; text-align: right; }
        table th { background: #4CAF50; color: white; }
        .media-url { word-break: break-all; font-size: 11px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Debug استوری - @<?php echo htmlspecialchars($username); ?></h1>
        
        <div class="info">
            <strong>📌 اطلاعات درخواست:</strong><br>
            نام کاربری: <code><?php echo $username; ?></code><br>
            HTTP Code: <strong><?php echo $httpCode; ?></strong>
        </div>
        
        <div class="section">
            <h2>🔗 URL درخواست:</h2>
            <pre><?php echo htmlspecialchars($url); ?></pre>
        </div>
        
        <div class="section">
            <h2>📦 پاسخ کامل API:</h2>
            <pre><?php echo htmlspecialchars(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); ?></pre>
        </div>
        
        <?php if (isset($result['ok']) && $result['ok'] === true): ?>
            <div class="section">
                <h2 class="success">✅ درخواست موفق بود</h2>
                
                <?php
                $stories = [];
                if (isset($result['result']['result']) && is_array($result['result']['result'])) {
                    $stories = $result['result']['result'];
                } elseif ($result['result'] === null) {
                    echo "<p class='error'>⚠️ result = null (استوری فعالی نداره)</p>";
                }
                
                if (!empty($stories)):
                ?>
                    <h3>📊 تعداد استوری‌ها: <?php echo count($stories); ?></h3>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>نوع</th>
                                <th>video_url</th>
                                <th>image_url</th>
                                <th>video_img</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($stories as $index => $story): ?>
                                <tr>
                                    <td><?php echo ($index + 1); ?></td>
                                    <td>
                                        <?php 
                                        if (isset($story['is_video']) && $story['is_video']) {
                                            echo "🎬 ویدیو";
                                        } else {
                                            echo "🖼 عکس";
                                        }
                                        ?>
                                    </td>
                                    <td class="media-url">
                                        <?php 
                                        if (isset($story['video_url'])) {
                                            echo "✅ دارد<br><small>" . substr($story['video_url'], 0, 50) . "...</small>";
                                        } else {
                                            echo "❌ ندارد";
                                        }
                                        ?>
                                    </td>
                                    <td class="media-url">
                                        <?php 
                                        if (isset($story['image_url'])) {
                                            echo "✅ دارد<br><small>" . substr($story['image_url'], 0, 50) . "...</small>";
                                        } else {
                                            echo "❌ ندارد";
                                        }
                                        ?>
                                    </td>
                                    <td class="media-url">
                                        <?php 
                                        if (isset($story['video_img'])) {
                                            echo "✅ دارد<br><small>" . substr($story['video_img'], 0, 50) . "...</small>";
                                        } else {
                                            echo "❌ ندارد";
                                        }
                                        ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    
                    <h3>📋 داده کامل هر استوری:</h3>
                    <?php foreach ($stories as $index => $story): ?>
                        <div style="margin: 15px 0; padding: 15px; background: #f5f5f5; border-radius: 5px;">
                            <h4>استوری <?php echo ($index + 1); ?>:</h4>
                            <pre><?php echo htmlspecialchars(json_encode($story, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); ?></pre>
                        </div>
                    <?php endforeach; ?>
                    
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="section">
                <h2 class="error">❌ درخواست ناموفق</h2>
                <?php if (isset($result['result'])): ?>
                    <p>خطا: <?php echo htmlspecialchars($result['result']['status'] ?? 'نامشخص'); ?></p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <div class="section">
            <h2>🧪 تست با نام کاربری دیگر:</h2>
            <form method="GET" style="margin: 20px 0;">
                <label>نام کاربری:</label><br>
                <input type="text" name="username" value="<?php echo $username; ?>" style="padding: 10px; width: 300px; margin: 10px 0;">
                <button type="submit" style="padding: 10px 20px; background: #4CAF50; color: white; border: none; border-radius: 5px; cursor: pointer;">🔍 بررسی</button>
            </form>
        </div>
        
    </div>
</body>
</html> 