<?php
/**
 * Log Viewer
 */

// Security: Only allow from localhost or specific IPs
$allowedIPs = ['127.0.0.1', '::1']; // Add your IP here if needed

echo "<h2>Bot Logs Viewer</h2>";
echo "<style>
body { font-family: monospace; background: #1e1e1e; color: #d4d4d4; padding: 20px; }
h2, h3 { color: #4ec9b0; }
pre { background: #252526; padding: 15px; border-radius: 5px; overflow-x: auto; border-left: 3px solid #007acc; }
.error { color: #f48771; }
.success { color: #4ec9b0; }
.warning { color: #dcdcaa; }
a { color: #4ec9b0; text-decoration: none; }
a:hover { text-decoration: underline; }
</style>";

echo "<p><a href='?refresh=1'>🔄 Refresh</a> | <a href='?clear=1' onclick='return confirm(\"Clear all logs?\")'>🗑️ Clear All Logs</a></p>";
echo "<hr>";

// Clear logs
if (isset($_GET['clear'])) {
    $logFiles = glob(__DIR__ . '/logs/*.log');
    foreach ($logFiles as $file) {
        @unlink($file);
    }
    echo "<p class='success'>✓ All logs cleared!</p>";
    echo "<p><a href='view_logs.php'>Back</a></p>";
    exit;
}

// Check if logs directory exists
if (!is_dir(__DIR__ . '/logs')) {
    echo "<p class='error'>✗ Logs directory not found. Creating...</p>";
    @mkdir(__DIR__ . '/logs', 0755, true);
}

// Get all log files
$logFiles = glob(__DIR__ . '/logs/*.log');

if (empty($logFiles)) {
    echo "<p class='warning'>⚠ No log files found yet.</p>";
    echo "<p>Try sending a message to your bot to generate logs.</p>";
} else {
    echo "<p class='success'>Found " . count($logFiles) . " log file(s)</p>";
    
    foreach ($logFiles as $logFile) {
        $fileName = basename($logFile);
        $fileSize = filesize($logFile);
        $fileTime = date('Y-m-d H:i:s', filemtime($logFile));
        
        echo "<h3>📄 {$fileName}</h3>";
        echo "<p>Size: " . number_format($fileSize) . " bytes | Modified: {$fileTime}</p>";
        
        if ($fileSize > 0) {
            $content = file_get_contents($logFile);
            
            // Limit to last 50 lines if too large
            if ($fileSize > 50000) {
                $lines = explode("\n", $content);
                $lines = array_slice($lines, -50);
                $content = implode("\n", $lines);
                echo "<p class='warning'>⚠ Showing last 50 lines (file is large)</p>";
            }
            
            // Highlight errors
            $content = htmlspecialchars($content);
            $content = preg_replace('/\[ERROR\]|\[FATAL\]|Error:|Fatal Error:/i', '<span class="error">$0</span>', $content);
            $content = preg_replace('/\[WARNING\]|Warning:/i', '<span class="warning">$0</span>', $content);
            $content = preg_replace('/\[SUCCESS\]|✓/i', '<span class="success">$0</span>', $content);
            
            echo "<pre>{$content}</pre>";
        } else {
            echo "<p class='warning'>⚠ File is empty</p>";
        }
        
        echo "<hr>";
    }
}

// Show recent PHP errors from server
echo "<h3>🔍 Recent PHP Errors (if any):</h3>";
$phpErrorLog = ini_get('error_log');
if ($phpErrorLog && file_exists($phpErrorLog)) {
    $errors = file_get_contents($phpErrorLog);
    $lines = explode("\n", $errors);
    $recentLines = array_slice($lines, -20);
    echo "<pre>" . htmlspecialchars(implode("\n", $recentLines)) . "</pre>";
} else {
    echo "<p>No PHP error log found or configured.</p>";
}

echo "<hr>";
echo "<p><small>Current time: " . date('Y-m-d H:i:s') . "</small></p>";
?>
