<?php
error_reporting(0);
include_once "../config.php";

$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);

if (!$db) {
    die("خطا در اتصال به دیتابیس: " . mysqli_connect_error());
}

echo "<h2>بروزرسانی دیتابیس برای سیستم پوشه‌بندی رسانه‌ها</h2>";

// بررسی وجود جدول folders
$check_folders = mysqli_query($db, "SHOW TABLES LIKE 'folders'");
if (mysqli_num_rows($check_folders) == 0) {
    $result = mysqli_multi_query($db, "CREATE TABLE `folders` (
      `id` int(11) AUTO_INCREMENT PRIMARY KEY,
      `name` varchar(255) COLLATE utf8mb4_bin NOT NULL,
      `parent_id` int(11) DEFAULT NULL,
      `order_position` int(11) DEFAULT 0,
      `created_at` int(20) DEFAULT 0,
      `created_by` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;");
    
    if ($result) {
        echo "<p style='color: green;'>✅ جدول folders با موفقیت ایجاد شد.</p>";
    } else {
        echo "<p style='color: red;'>❌ خطا در ایجاد جدول folders: " . mysqli_error($db) . "</p>";
    }
} else {
    echo "<p style='color: blue;'>ℹ️ جدول folders از قبل موجود است.</p>";
}

// بررسی وجود جدول folder_files
$check_folder_files = mysqli_query($db, "SHOW TABLES LIKE 'folder_files'");
if (mysqli_num_rows($check_folder_files) == 0) {
    $result = mysqli_multi_query($db, "CREATE TABLE `folder_files` (
      `id` int(11) AUTO_INCREMENT PRIMARY KEY,
      `folder_id` int(11) NOT NULL,
      `file_id` varchar(20) COLLATE utf8mb4_bin NOT NULL,
      `created_at` int(20) DEFAULT 0
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;");
    
    if ($result) {
        echo "<p style='color: green;'>✅ جدول folder_files با موفقیت ایجاد شد.</p>";
    } else {
        echo "<p style='color: red;'>❌ خطا در ایجاد جدول folder_files: " . mysqli_error($db) . "</p>";
    }
} else {
    echo "<p style='color: blue;'>ℹ️ جدول folder_files از قبل موجود است.</p>";
}

// اضافه کردن تنظیمات
$check_setting = mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'folders_enabled'");
if (mysqli_num_rows($check_setting) == 0) {
    $result = mysqli_query($db, "INSERT INTO `settings` (`type`, `type_id`, `columnOne`, `columnTwo`) VALUES ('folders_enabled', 'on', '', '')");
    if ($result) {
        echo "<p style='color: green;'>✅ تنظیمات پوشه‌بندی با موفقیت اضافه شد.</p>";
    } else {
        echo "<p style='color: red;'>❌ خطا در اضافه کردن تنظیمات: " . mysqli_error($db) . "</p>";
    }
} else {
    echo "<p style='color: blue;'>ℹ️ تنظیمات پوشه‌بندی از قبل موجود است.</p>";
}

echo "<h3>🎉 بروزرسانی کامل شد!</h3>";
echo "<p>اکنون می‌توانید از قسمت <strong>پوشه سازی رسانه ها</strong> در پنل ادمین استفاده کنید.</p>";
echo "<p><a href='../bot.php'>🔙 بازگشت به ربات</a></p>";

mysqli_close($db);
?> 