<?php
$base_dir = __DIR__;
require_once $base_dir . '/config.php';
require_once $base_dir . '/functions.php';

// چک کردن فایل‌های در حال پردازش
$broadcast_file = $base_dir . '/broadcast_processed.json';
$forward_file = $base_dir . '/forward_processed.json';

// پردازش ارسال همگانی
if (file_exists($broadcast_file)) {
    $data = json_decode(file_get_contents($broadcast_file), true);
    if ($data && isset($data['message_id'])) {
        broadcast_message($data['message_id'], $data['status_chat_id'], $data['status_message_id']);
    }
}

// پردازش فوروارد همگانی
if (file_exists($forward_file)) {
    $data = json_decode(file_get_contents($forward_file), true);
    if ($data && isset($data['message_id'])) {
        $parts = explode(':', $data['message_id']);
        if (count($parts) == 2) {
            forward_message_to_all($parts[0], $parts[1], $data['status_chat_id'], $data['status_message_id']);
        }
    }
} 