<?php
/*
=====================================
   اسکریپت آپدیت ساختار پوشه‌سازی
=====================================
این اسکریپت ساختار جدول folders را آپدیت می‌کند
تا قابلیت مرتب‌سازی بر اساس تاریخ ایجاد را فعال کند
*/

error_reporting(E_ALL);
ini_set('display_errors', 1);

// اطلاعات دیتابیس
include_once "config.php";

echo "🚀 شروع آپدیت ساختار دیتابیس پوشه‌سازی...\n";
echo str_repeat("=", 50) . "\n\n";

// اتصال به دیتابیس
$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);

if (!$db) {
    die("❌ خطا در اتصال به دیتابیس: " . mysqli_connect_error() . "\n");
}

mysqli_set_charset($db, 'utf8mb4');
echo "✅ اتصال به دیتابیس موفق بود\n\n";

// ========== بررسی وجود جدول folders ==========
echo "🔍 بررسی وجود جدول folders...\n";
$check_table = mysqli_query($db, "SHOW TABLES LIKE 'folders'");
if (mysqli_num_rows($check_table) == 0) {
    echo "📦 جدول folders وجود ندارد، در حال ایجاد...\n";
    
    $create_table = "CREATE TABLE `folders` (
        `id` int(11) AUTO_INCREMENT PRIMARY KEY,
        `name` varchar(255) COLLATE utf8mb4_bin NOT NULL,
        `parent_id` int(11) DEFAULT NULL,
        `order_position` int(11) DEFAULT 0,
        `created_at` int(20) DEFAULT 0,
        `created_by` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
        KEY `idx_parent_id` (`parent_id`),
        KEY `idx_created_at` (`created_at`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin";
    
    if (mysqli_query($db, $create_table)) {
        echo "✅ جدول folders با موفقیت ایجاد شد\n";
    } else {
        die("❌ خطا در ایجاد جدول folders: " . mysqli_error($db) . "\n");
    }
} else {
    echo "✅ جدول folders وجود دارد\n";
}

// ========== بررسی وجود جدول folder_files ==========
echo "🔍 بررسی وجود جدول folder_files...\n";
$check_table = mysqli_query($db, "SHOW TABLES LIKE 'folder_files'");
if (mysqli_num_rows($check_table) == 0) {
    echo "📦 جدول folder_files وجود ندارد، در حال ایجاد...\n";
    
    $create_table = "CREATE TABLE `folder_files` (
        `id` int(11) AUTO_INCREMENT PRIMARY KEY,
        `folder_id` int(11) NOT NULL,
        `file_id` varchar(20) COLLATE utf8mb4_bin NOT NULL,
        `created_at` int(20) DEFAULT 0,
        KEY `idx_folder_id` (`folder_id`),
        KEY `idx_file_id` (`file_id`),
        KEY `idx_created_at` (`created_at`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin";
    
    if (mysqli_query($db, $create_table)) {
        echo "✅ جدول folder_files با موفقیت ایجاد شد\n";
    } else {
        die("❌ خطا در ایجاد جدول folder_files: " . mysqli_error($db) . "\n");
    }
} else {
    echo "✅ جدول folder_files وجود دارد\n";
}

// ========== بررسی وجود ستون‌های مورد نیاز ==========
echo "\n🔍 بررسی ساختار جدول folders...\n";

// بررسی ستون created_at
$check_column = mysqli_query($db, "SHOW COLUMNS FROM `folders` LIKE 'created_at'");
if (mysqli_num_rows($check_column) == 0) {
    echo "➕ در حال افزودن ستون created_at...\n";
    if (mysqli_query($db, "ALTER TABLE `folders` ADD COLUMN `created_at` int(20) DEFAULT 0")) {
        echo "✅ ستون created_at اضافه شد\n";
    } else {
        echo "❌ خطا در افزودن ستون created_at: " . mysqli_error($db) . "\n";
    }
} else {
    echo "✅ ستون created_at وجود دارد\n";
}

// بررسی ستون created_by
$check_column = mysqli_query($db, "SHOW COLUMNS FROM `folders` LIKE 'created_by'");
if (mysqli_num_rows($check_column) == 0) {
    echo "➕ در حال افزودن ستون created_by...\n";
    if (mysqli_query($db, "ALTER TABLE `folders` ADD COLUMN `created_by` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL")) {
        echo "✅ ستون created_by اضافه شد\n";
    } else {
        echo "❌ خطا در افزودن ستون created_by: " . mysqli_error($db) . "\n";
    }
} else {
    echo "✅ ستون created_by وجود دارد\n";
}

// ========== آپدیت داده‌های موجود ==========
echo "\n🔄 آپدیت داده‌های موجود...\n";

// تنظیم created_at برای پوشه‌هایی که مقدار ندارند
$current_time = time();
$result = mysqli_query($db, "UPDATE `folders` SET `created_at` = $current_time WHERE `created_at` = 0 OR `created_at` IS NULL");
if ($result) {
    $affected_rows = mysqli_affected_rows($db);
    echo "✅ تاریخ ایجاد برای $affected_rows پوشه آپدیت شد\n";
} else {
    echo "❌ خطا در آپدیت تاریخ‌ها: " . mysqli_error($db) . "\n";
}

// ========== بررسی فایل‌های پوشه ==========
echo "\n🔍 بررسی ساختار جدول folder_files...\n";

// بررسی ستون created_at در folder_files
$check_column = mysqli_query($db, "SHOW COLUMNS FROM `folder_files` LIKE 'created_at'");
if (mysqli_num_rows($check_column) == 0) {
    echo "➕ در حال افزودن ستون created_at به folder_files...\n";
    if (mysqli_query($db, "ALTER TABLE `folder_files` ADD COLUMN `created_at` int(20) DEFAULT 0")) {
        echo "✅ ستون created_at به folder_files اضافه شد\n";
        
        // آپدیت داده‌های موجود
        if (mysqli_query($db, "UPDATE `folder_files` SET `created_at` = $current_time WHERE `created_at` = 0 OR `created_at` IS NULL")) {
            $affected_rows = mysqli_affected_rows($db);
            echo "✅ تاریخ ایجاد برای $affected_rows رابطه فایل-پوشه آپدیت شد\n";
        }
    } else {
        echo "❌ خطا در افزودن ستون created_at به folder_files: " . mysqli_error($db) . "\n";
    }
} else {
    echo "✅ ستون created_at در folder_files وجود دارد\n";
}

// ========== افزودن ایندکس‌ها برای بهتر شدن عملکرد ==========
echo "\n🔧 بهینه‌سازی ایندکس‌ها...\n";

// ایندکس برای created_at در folders
$check_index = mysqli_query($db, "SHOW INDEX FROM `folders` WHERE Key_name = 'idx_created_at'");
if (mysqli_num_rows($check_index) == 0) {
    if (mysqli_query($db, "ALTER TABLE `folders` ADD INDEX `idx_created_at` (`created_at`)")) {
        echo "✅ ایندکس created_at برای folders اضافه شد\n";
    } else {
        echo "❌ خطا در افزودن ایندکس: " . mysqli_error($db) . "\n";
    }
} else {
    echo "✅ ایندکس created_at برای folders وجود دارد\n";
}

// ایندکس برای parent_id در folders
$check_index = mysqli_query($db, "SHOW INDEX FROM `folders` WHERE Key_name = 'idx_parent_id'");
if (mysqli_num_rows($check_index) == 0) {
    if (mysqli_query($db, "ALTER TABLE `folders` ADD INDEX `idx_parent_id` (`parent_id`)")) {
        echo "✅ ایندکس parent_id برای folders اضافه شد\n";
    } else {
        echo "❌ خطا در افزودن ایندکس: " . mysqli_error($db) . "\n";
    }
} else {
    echo "✅ ایندکس parent_id برای folders وجود دارد\n";
}

// ========== آمار نهایی ==========
echo "\n📊 آمار نهایی:\n";
echo str_repeat("-", 30) . "\n";

$folder_count = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) as count FROM `folders`"))['count'];
echo "📁 تعداد کل پوشه‌ها: $folder_count\n";

$main_folder_count = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) as count FROM `folders` WHERE `parent_id` IS NULL"))['count'];
echo "📂 تعداد پوشه‌های اصلی: $main_folder_count\n";

$sub_folder_count = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) as count FROM `folders` WHERE `parent_id` IS NOT NULL"))['count'];
echo "📁 تعداد زیرپوشه‌ها: $sub_folder_count\n";

$file_relation_count = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) as count FROM `folder_files`"))['count'];
echo "🔗 تعداد ارتباط فایل-پوشه: $file_relation_count\n";

echo "\n🎉 آپدیت ساختار دیتابیس با موفقیت تمام شد!\n";
echo "📝 تغییرات اعمال شده:\n";
echo "   • زیرپوشه‌های جدید حالا در بالای لیست نمایش داده می‌شوند\n";
echo "   • قابلیت تغییر نام پوشه‌ها و زیرپوشه‌ها اضافه شد\n";
echo "   • ایندکس‌های مناسب برای بهبود عملکرد اضافه شدند\n";
echo str_repeat("=", 50) . "\n";

// بستن اتصال
mysqli_close($db);
echo "✅ اتصال دیتابیس بسته شد\n";
?> 