<?php
/*
========================================
    ابزار ساده انتقال ربات آپلودک  
========================================
این اسکریپت ساده برای انتقال سریع دیتابیس 
از ربات قدیمی به ربات جدید
*/

error_reporting(E_ALL);
ini_set('display_errors', 1);

// ========== تنظیمات ==========
// اطلاعات دیتابیس قدیمی
$OLD_DB_HOST = 'localhost';
$OLD_DB_USER = 'sourcesh_newup';
$OLD_DB_PASS = '484DDGDh_548';
$OLD_DB_NAME = 'sourcesh_newup';

// اطلاعات دیتابیس جدید (تنظیم کنید)
$NEW_DB_HOST = 'localhost';
$NEW_DB_USER = 'sourcesh_newup2';
$NEW_DB_PASS = '484DDGDh_548';
$NEW_DB_NAME = 'sourcesh_newup2';

// یوزرنیم ربات‌ها
$OLD_BOT_USERNAME = 'FilmSerialArchiveBot';
$NEW_BOT_USERNAME = 'tvu3bot';

// ========== اتصال به دیتابیس ==========
function connectDB($host, $user, $pass, $dbname, $label) {
    $conn = mysqli_connect($host, $user, $pass, $dbname);
    if (!$conn) {
        die("خطا در اتصال به دیتابیس $label: " . mysqli_connect_error());
    }
    mysqli_set_charset($conn, 'utf8mb4');
    echo "✅ اتصال به دیتابیس $label موفق بود\n";
    return $conn;
}

// ========== ایجاد جداول ==========
function createTables($conn) {
    $tables = [
        "CREATE TABLE IF NOT EXISTS `file` (
            `row` int(11) AUTO_INCREMENT PRIMARY KEY,
            `id` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
            `type` varchar(50) COLLATE utf8mb4_bin DEFAULT NULL,
            `file_id` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL,
            `caption` text COLLATE utf8mb4_bin,
            `password` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL,
            `user_id` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
            `file_size` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
            `downloads` int(11) NOT NULL DEFAULT '0',
            `date` char(200) COLLATE utf8mb4_bin DEFAULT NULL,
            `time` char(200) COLLATE utf8mb4_bin DEFAULT NULL,
            UNIQUE KEY `unique_id` (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin",
        
        "CREATE TABLE IF NOT EXISTS `user` (
            `row` int(11) AUTO_INCREMENT PRIMARY KEY,
            `from_id` varchar(20) COLLATE utf8mb4_bin NOT NULL,
            `step` varchar(50) COLLATE utf8mb4_bin DEFAULT NULL,
            `downloads` int(20) NOT NULL DEFAULT '0',
            `getFile` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL,
            `block` int(11) NOT NULL DEFAULT '0',
            `spam` text COLLATE utf8mb4_bin,
            `update_at` int(20) DEFAULT '0',
            `create_at` int(20) DEFAULT '0',
            UNIQUE KEY `unique_user` (`from_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin",
        
        "CREATE TABLE IF NOT EXISTS `folders` (
            `row` int(11) AUTO_INCREMENT PRIMARY KEY,
            `id` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
            `name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL,
            `user_id` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
            `date` char(200) COLLATE utf8mb4_bin DEFAULT NULL,
            `time` char(200) COLLATE utf8mb4_bin DEFAULT NULL,
            UNIQUE KEY `unique_folder_id` (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin",
        
        "CREATE TABLE IF NOT EXISTS `folder_files` (
            `row` int(11) AUTO_INCREMENT PRIMARY KEY,
            `folder_id` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
            `file_id` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL,
            `date` char(200) COLLATE utf8mb4_bin DEFAULT NULL,
            `time` char(200) COLLATE utf8mb4_bin DEFAULT NULL,
            KEY `folder_id` (`folder_id`),
            KEY `file_id` (`file_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin"
    ];
    
    foreach ($tables as $sql) {
        if (!mysqli_query($conn, $sql)) {
            echo "❌ خطا در ایجاد جدول: " . mysqli_error($conn) . "\n";
            return false;
        }
    }
    echo "✅ جداول با موفقیت ایجاد شدند\n";
    return true;
}

// ========== انتقال فایل‌ها ==========
function migrateFiles($oldDB, $newDB) {
    echo "🔄 شروع انتقال فایل‌ها...\n";
    
    $result = mysqli_query($oldDB, "SELECT COUNT(*) as total FROM `file`");
    $totalFiles = mysqli_fetch_assoc($result)['total'];
    echo "📊 تعداد کل فایل‌ها: $totalFiles\n";
    
    $migrated = 0;
    $skipped = 0;
    $batchSize = 100;
    $offset = 0;
    
    while ($offset < $totalFiles) {
        $query = "SELECT * FROM `file` LIMIT $batchSize OFFSET $offset";
        $result = mysqli_query($oldDB, $query);
        
        while ($file = mysqli_fetch_assoc($result)) {
            // بررسی وجود فایل در دیتابیس جدید
            $checkQuery = "SELECT id FROM `file` WHERE id = '" . mysqli_real_escape_string($newDB, $file['id']) . "'";
            $checkResult = mysqli_query($newDB, $checkQuery);
            
            if (mysqli_num_rows($checkResult) > 0) {
                $skipped++;
                continue;
            }
            
            // وارد کردن فایل جدید
            $insertQuery = "INSERT INTO `file` (id, type, file_id, caption, password, user_id, file_size, downloads, date, time) VALUES (
                '" . mysqli_real_escape_string($newDB, $file['id']) . "',
                '" . mysqli_real_escape_string($newDB, $file['type']) . "',
                '" . mysqli_real_escape_string($newDB, $file['file_id']) . "',
                '" . mysqli_real_escape_string($newDB, $file['caption']) . "',
                '" . mysqli_real_escape_string($newDB, $file['password']) . "',
                '" . mysqli_real_escape_string($newDB, $file['user_id']) . "',
                '" . mysqli_real_escape_string($newDB, $file['file_size']) . "',
                '" . mysqli_real_escape_string($newDB, $file['downloads']) . "',
                '" . mysqli_real_escape_string($newDB, $file['date']) . "',
                '" . mysqli_real_escape_string($newDB, $file['time']) . "'
            )";
            
            if (mysqli_query($newDB, $insertQuery)) {
                $migrated++;
            } else {
                echo "❌ خطا در فایل {$file['id']}: " . mysqli_error($newDB) . "\n";
            }
        }
        
        $offset += $batchSize;
        $progress = min(100, ($offset / $totalFiles) * 100);
        echo "📈 پیشرفت: " . number_format($progress, 1) . "% ($migrated منتقل شده, $skipped رد شده)\n";
    }
    
    echo "✅ انتقال فایل‌ها تمام شد: $migrated منتقل شده, $skipped رد شده\n";
    return $migrated;
}

// ========== انتقال پوشه‌ها ==========
function migrateFolders($oldDB, $newDB) {
    echo "🔄 شروع انتقال پوشه‌ها...\n";
    
    $result = mysqli_query($oldDB, "SELECT COUNT(*) as total FROM `folders`");
    if (!$result) {
        echo "⚠️  جدول folders در دیتابیس قدیمی وجود ندارد، رد می‌شود\n";
        return 0;
    }
    
    $totalFolders = mysqli_fetch_assoc($result)['total'];
    echo "📊 تعداد کل پوشه‌ها: $totalFolders\n";
    
    if ($totalFolders == 0) {
        echo "✅ هیچ پوشه‌ای برای انتقال وجود ندارد\n";
        return 0;
    }
    
    $migrated = 0;
    $skipped = 0;
    
    $result = mysqli_query($oldDB, "SELECT * FROM `folders`");
    
    while ($folder = mysqli_fetch_assoc($result)) {
        // بررسی وجود پوشه در دیتابیس جدید
        $checkQuery = "SELECT id FROM `folders` WHERE id = '" . mysqli_real_escape_string($newDB, $folder['id']) . "'";
        $checkResult = mysqli_query($newDB, $checkQuery);
        
        if (mysqli_num_rows($checkResult) > 0) {
            $skipped++;
            continue;
        }
        
        // وارد کردن پوشه جدید
        $user_id = isset($folder['user_id']) ? $folder['user_id'] : '';
        $date = isset($folder['date']) ? $folder['date'] : date('Y-m-d');
        $time = isset($folder['time']) ? $folder['time'] : date('H:i:s');
        
        $insertQuery = "INSERT INTO `folders` (id, name, user_id, date, time) VALUES (
            '" . mysqli_real_escape_string($newDB, $folder['id']) . "',
            '" . mysqli_real_escape_string($newDB, $folder['name']) . "',
            '" . mysqli_real_escape_string($newDB, $user_id) . "',
            '" . mysqli_real_escape_string($newDB, $date) . "',
            '" . mysqli_real_escape_string($newDB, $time) . "'
        )";
        
        if (mysqli_query($newDB, $insertQuery)) {
            $migrated++;
        } else {
            echo "❌ خطا در پوشه {$folder['id']}: " . mysqli_error($newDB) . "\n";
        }
    }
    
    echo "✅ انتقال پوشه‌ها تمام شد: $migrated منتقل شده, $skipped رد شده\n";
    return $migrated;
}

// ========== انتقال فایل‌های پوشه ==========
function migrateFolderFiles($oldDB, $newDB) {
    echo "🔄 شروع انتقال ارتباط فایل‌ها و پوشه‌ها...\n";
    
    $result = mysqli_query($oldDB, "SELECT COUNT(*) as total FROM `folder_files`");
    if (!$result) {
        echo "⚠️  جدول folder_files در دیتابیس قدیمی وجود ندارد، رد می‌شود\n";
        return 0;
    }
    
    $totalRelations = mysqli_fetch_assoc($result)['total'];
    echo "📊 تعداد کل ارتباطات: $totalRelations\n";
    
    if ($totalRelations == 0) {
        echo "✅ هیچ ارتباطی برای انتقال وجود ندارد\n";
        return 0;
    }
    
    $migrated = 0;
    $skipped = 0;
    
    $result = mysqli_query($oldDB, "SELECT * FROM `folder_files`");
    
    while ($relation = mysqli_fetch_assoc($result)) {
        // بررسی وجود ارتباط در دیتابیس جدید
        $checkQuery = "SELECT row FROM `folder_files` WHERE folder_id = '" . mysqli_real_escape_string($newDB, $relation['folder_id']) . "' AND file_id = '" . mysqli_real_escape_string($newDB, $relation['file_id']) . "'";
        $checkResult = mysqli_query($newDB, $checkQuery);
        
        if (mysqli_num_rows($checkResult) > 0) {
            $skipped++;
            continue;
        }
        
        // وارد کردن ارتباط جدید
        $date = isset($relation['date']) ? $relation['date'] : date('Y-m-d');
        $time = isset($relation['time']) ? $relation['time'] : date('H:i:s');
        
        $insertQuery = "INSERT INTO `folder_files` (folder_id, file_id, date, time) VALUES (
            '" . mysqli_real_escape_string($newDB, $relation['folder_id']) . "',
            '" . mysqli_real_escape_string($newDB, $relation['file_id']) . "',
            '" . mysqli_real_escape_string($newDB, $date) . "',
            '" . mysqli_real_escape_string($newDB, $time) . "'
        )";
        
        if (mysqli_query($newDB, $insertQuery)) {
            $migrated++;
        } else {
            echo "❌ خطا در ارتباط {$relation['folder_id']}-{$relation['file_id']}: " . mysqli_error($newDB) . "\n";
        }
    }
    
    echo "✅ انتقال ارتباط فایل‌ها و پوشه‌ها تمام شد: $migrated منتقل شده, $skipped رد شده\n";
    return $migrated;
}

// ========== انتقال کاربران ==========
function migrateUsers($oldDB, $newDB) {
    echo "🔄 شروع انتقال کاربران...\n";
    
    $result = mysqli_query($oldDB, "SELECT * FROM `user`");
    $migrated = 0;
    $updated = 0;
    
    while ($user = mysqli_fetch_assoc($result)) {
        // بررسی وجود کاربر
        $checkQuery = "SELECT from_id FROM `user` WHERE from_id = '" . mysqli_real_escape_string($newDB, $user['from_id']) . "'";
        $checkResult = mysqli_query($newDB, $checkQuery);
        
        if (mysqli_num_rows($checkResult) > 0) {
            // بروزرسانی اطلاعات کاربر موجود
            $updateQuery = "UPDATE `user` SET 
                downloads = downloads + " . intval($user['downloads']) . ",
                update_at = " . intval($user['update_at']) . "
                WHERE from_id = '" . mysqli_real_escape_string($newDB, $user['from_id']) . "'";
            
            if (mysqli_query($newDB, $updateQuery)) {
                $updated++;
            }
        } else {
            // وارد کردن کاربر جدید
            $insertQuery = "INSERT INTO `user` (from_id, step, downloads, getFile, block, spam, update_at, create_at) VALUES (
                '" . mysqli_real_escape_string($newDB, $user['from_id']) . "',
                '" . mysqli_real_escape_string($newDB, $user['step']) . "',
                " . intval($user['downloads']) . ",
                '" . mysqli_real_escape_string($newDB, $user['getFile']) . "',
                " . intval($user['block']) . ",
                '" . mysqli_real_escape_string($newDB, $user['spam']) . "',
                " . intval($user['update_at']) . ",
                " . intval($user['create_at']) . "
            )";
            
            if (mysqli_query($newDB, $insertQuery)) {
                $migrated++;
            }
        }
    }
    
    echo "✅ انتقال کاربران تمام شد: $migrated جدید, $updated بروزرسانی شده\n";
}

// ========== تولید گزارش لینک‌ها ==========
function generateLinkReport($newDB, $oldBotUsername, $newBotUsername) {
    echo "📄 تولید گزارش لینک‌ها...\n";
    
    $reportFile = "link_report_" . date('Y-m-d_H-i-s') . ".txt";
    $report = "گزارش تبدیل لینک‌های ربات\n";
    $report .= "تاریخ: " . date('Y-m-d H:i:s') . "\n";
    $report .= str_repeat("=", 50) . "\n\n";
    
    $report .= "ربات قدیمی: @$oldBotUsername\n";
    $report .= "ربات جدید: @$newBotUsername\n\n";
    
    $result = mysqli_query($newDB, "SELECT id, type, caption FROM `file` ORDER BY downloads DESC LIMIT 10");
    
    $report .= "🔗 نمونه لینک‌های محبوب:\n";
    $report .= str_repeat("-", 30) . "\n";
    
    while ($file = mysqli_fetch_assoc($result)) {
        $oldLink = "https://t.me/$oldBotUsername?start=get_{$file['id']}";
        $newLink = "https://t.me/$newBotUsername?start=get_{$file['id']}";
        
        $report .= "شناسه: {$file['id']}\n";
        $report .= "نوع: {$file['type']}\n";
        $report .= "لینک قدیمی: $oldLink\n";
        $report .= "لینک جدید: $newLink\n";
        $report .= str_repeat("-", 30) . "\n";
    }
    
    $report .= "\n💡 تمام فایل‌ها با همان شناسه قبلی کار می‌کنند\n";
    $report .= "فقط نام ربات در لینک عوض شده است\n";
    
    file_put_contents($reportFile, $report);
    echo "✅ گزارش در فایل $reportFile ذخیره شد\n";
}

// ========== اجرای اصلی ==========
echo "🚀 شروع انتقال ربات آپلودک\n";
echo str_repeat("=", 40) . "\n";

// اتصال به دیتابیس‌ها
$oldDB = connectDB($OLD_DB_HOST, $OLD_DB_USER, $OLD_DB_PASS, $OLD_DB_NAME, "قدیمی");
$newDB = connectDB($NEW_DB_HOST, $NEW_DB_USER, $NEW_DB_PASS, $NEW_DB_NAME, "جدید");

// ایجاد جداول
if (!createTables($newDB)) {
    die("❌ خطا در ایجاد جداول\n");
}

// انتقال داده‌ها
$migratedFiles = migrateFiles($oldDB, $newDB);
$migratedFolders = migrateFolders($oldDB, $newDB);
$migratedFolderFiles = migrateFolderFiles($oldDB, $newDB);
migrateUsers($oldDB, $newDB);

// تولید گزارش
generateLinkReport($newDB, $OLD_BOT_USERNAME, $NEW_BOT_USERNAME);

echo "\n🎉 انتقال با موفقیت تمام شد!\n";
echo "📊 تعداد فایل‌های منتقل شده: $migratedFiles\n";
echo "📁 تعداد پوشه‌های منتقل شده: $migratedFolders\n";
echo "🔗 تعداد ارتباط فایل-پوشه منتقل شده: $migratedFolderFiles\n";
echo "🔗 تمام لینک‌های قدیمی حالا با ربات جدید کار می‌کنند\n";
echo str_repeat("=", 40) . "\n";

// بستن اتصالات
mysqli_close($oldDB);
mysqli_close($newDB);
?> 