# 📦 راهنمای نصب - ربات مدیریت گروه تلگرام v2.0

## 🎯 مراحل نصب سریع (5 دقیقه)

### مرحله 1: دانلود و آپلود

1. تمام فایل‌های پوشه `bot-v2` را دانلود کنید
2. فایل‌ها را در سرور خود آپلود کنید (مثلاً در `/public_html/bot-v2/`)
3. مجوزهای فایل‌ها را تنظیم کنید:
   ```bash
   chmod 755 bot-v2/
   chmod 644 bot-v2/*.php
   chmod 755 bot-v2/data/
   chmod 755 bot-v2/logs/
   chmod 755 bot-v2/cache/
   ```

---

### مرحله 2: ساخت دیتابیس

1. وارد cPanel یا phpMyAdmin شوید
2. یک دیتابیس MySQL جدید بسازید
3. یک کاربر برای دیتابیس بسازید و تمام مجوزها را بدهید
4. نام دیتابیس، کاربر و رمز را یادداشت کنید

---

### مرحله 3: تنظیم config.php

فایل `config.php` را باز کنید و موارد زیر را تنظیم کنید:

```php
// 1. توکن ربات (از @BotFather دریافت کنید)
define('BOT_TOKEN', '123456789:ABCdefGHIjklMNOpqrsTUVwxyz');

// 2. یوزرنیم ربات (بدون @)
define('BOT_USERNAME', 'YourBotUsername');

// 3. اطلاعات دیتابیس
define('DB_HOST', 'localhost');
define('DB_USER', 'your_database_user');
define('DB_PASS', 'your_database_password');
define('DB_NAME', 'your_database_name');

// 4. آیدی ادمین‌ها (آیدی عددی خودتان)
define('ADMIN_IDS', [123456789]);

// 5. کانال و گروه پشتیبانی
define('SUPPORT_CHANNEL', '@YourChannel');
define('SUPPORT_GROUP', 'https://t.me/joinchat/XXXXX');
```

**💡 نکته:** برای دریافت آیدی عددی خود، به ربات [@userinfobot](https://t.me/userinfobot) پیام `/start` بدهید.

---

### مرحله 4: تنظیم Webhook

#### روش 1: از طریق مرورگر

در مرورگر آدرس زیر را باز کنید (توکن و آدرس را جایگزین کنید):

```
https://api.telegram.org/bot123456789:ABCdefGHIjklMNOpqrsTUVwxyz/setWebhook?url=https://yourdomain.com/bot-v2/index.php
```

باید پیام زیر را ببینید:
```json
{"ok":true,"result":true,"description":"Webhook was set"}
```

#### روش 2: از طریق PHP

فایل `setup_webhook.php` بسازید:

```php
<?php
$token = "123456789:ABCdefGHIjklMNOpqrsTUVwxyz";
$webhookUrl = "https://yourdomain.com/bot-v2/index.php";

$result = file_get_contents("https://api.telegram.org/bot{$token}/setWebhook?url={$webhookUrl}");
echo $result;
```

فایل را در مرورگر باز کنید و بعد از تنظیم، حذفش کنید.

---

### مرحله 5: تست ربات

1. به ربات خود در تلگرام پیام `/start` بدهید
2. باید پیام خوشامدگویی دریافت کنید
3. ربات را به یک گروه تست اضافه کنید
4. در گروه دستور `/start` یا `نصب` را بفرستید
5. ربات باید نصب شود و پیام تأیید بفرستد

---

### مرحله 6: تنظیم Cron Jobs (اختیاری)

برای فعال کردن ارسال همگانی و حذف خودکار پیام‌ها:

#### در cPanel:

1. به بخش Cron Jobs بروید
2. دو cron job زیر را اضافه کنید:

**Cron 1: حذف خودکار پیام‌ها**
```
* * * * * /usr/bin/php /home/username/public_html/bot-v2/cron/delete_messages.php
```

**Cron 2: ارسال همگانی**
```
* * * * * /usr/bin/php /home/username/public_html/bot-v2/cron/send_all.php
```

#### در سرور لینوکس:

```bash
crontab -e
```

سپس این خطوط را اضافه کنید:
```
* * * * * php /path/to/bot-v2/cron/delete_messages.php >> /path/to/bot-v2/logs/cron.log 2>&1
* * * * * php /path/to/bot-v2/cron/send_all.php >> /path/to/bot-v2/logs/cron.log 2>&1
```

---

## ✅ چک‌لیست نصب

- [ ] فایل‌ها آپلود شدند
- [ ] مجوزهای فایل‌ها تنظیم شد
- [ ] دیتابیس ساخته شد
- [ ] config.php تنظیم شد
- [ ] Webhook تنظیم شد
- [ ] ربات در پیوی تست شد
- [ ] ربات در گروه نصب شد
- [ ] Cron jobs تنظیم شدند (اختیاری)

---

## 🔍 عیب‌یابی

### ربات پاسخ نمیدهد

1. **چک کردن Webhook:**
   ```
   https://api.telegram.org/botYOUR_TOKEN/getWebhookInfo
   ```
   باید `url` شما را نشان دهد و `last_error_message` خالی باشد.

2. **چک کردن لاگ‌ها:**
   ```bash
   tail -f bot-v2/logs/telegram_errors_*.log
   tail -f bot-v2/logs/db_errors_*.log
   ```

3. **چک کردن مجوزها:**
   ```bash
   ls -la bot-v2/
   ```
   پوشه‌های data, logs, cache باید قابل نوشتن باشند.

### خطای دیتابیس

1. اطلاعات اتصال در config.php را چک کنید
2. مطمئن شوید کاربر دیتابیس تمام مجوزها را دارد
3. لاگ `db_errors_*.log` را بررسی کنید

### خطای 500

1. Debug mode را فعال کنید:
   ```php
   define('DEBUG_MODE', true);
   ```
2. خطاها را در مرورگر ببینید
3. بعد از رفع مشکل، Debug mode را خاموش کنید

---

## 🔐 نکات امنیتی

1. ✅ **هرگز توکن ربات را به اشتراک نگذارید**
2. ✅ **از HTTPS برای webhook استفاده کنید**
3. ✅ **رمز دیتابیس قوی انتخاب کنید**
4. ✅ **فایل config.php را محافظت کنید** (با .htaccess)
5. ✅ **Debug mode را در production خاموش کنید**
6. ✅ **Backup منظم از دیتابیس بگیرید**

---

## 📞 پشتیبانی

اگر مشکلی در نصب داشتید:

- 📢 کانال: @YourChannel
- 💬 گروه: https://t.me/joinchat/XXXXX
- 📧 ایمیل: support@yourdomain.com

---

## 🎉 تبریک!

ربات شما با موفقیت نصب شد! حالا می‌توانید از تمام قابلیت‌های آن استفاده کنید.

برای آشنایی با دستورات، در گروه خود `/help` را ارسال کنید.

---

**نسخه:** 2.0  
**تاریخ:** 1404/08/05  

