<?php
// تنظیمات اصلی
$token = "8254012412:AAHJLa-LZ_5mwdJIG8dYLp9edQs_S0nmuBg";
$api = "https://api.telegram.org/bot$token/";
$admin_ids = [6954953563]; // آیدی ادمین اصلی
$config = [
    'signature' => '@koongooshadbot', // اصلاح امضای پیش‌فرض
    'admin_ids' => $admin_ids,
    'file_signature_enabled' => true,
    'additional_text' => '',
    'additional_text_position' => 'after'
];

// خواندن تنظیمات از فایل
if (file_exists('config.json')) {
    $saved_config = json_decode(file_get_contents('config.json'), true);
    if ($saved_config) {
        // حفظ آیدی ادمین اصلی
        if (!in_array(6954953563, $saved_config['admin_ids'])) {
            $saved_config['admin_ids'][] = 6954953563;
        }
        $config = $saved_config;
        $admin_ids = $config['admin_ids'];
    }
}

// ذخیره تنظیمات
file_put_contents('config.json', json_encode($config, JSON_PRETTY_PRINT));

$update = json_decode(file_get_contents("php://input"), true);

// توابع کمکی
function isAdmin($user_id) {
    global $admin_ids;
    return in_array((int)$user_id, array_map('intval', $admin_ids));
}

function saveConfig() {
    global $config;
    file_put_contents('config.json', json_encode($config, JSON_PRETTY_PRINT));
}

function replaceUsername($text) {
    global $config;
    if (!$text) return "";
    return preg_replace('/@\s*\w+/', $config['signature'], $text); // اصلاح regex برای حذف فاصله‌ها
}

function addAdditionalText($caption) {
    global $config;
    if (empty($config['additional_text'])) return $caption;
    
    $additional = $config['additional_text'];
    if (empty($caption)) return $additional;
    
    return $config['additional_text_position'] === 'before' 
        ? $additional . "\n\n" . $caption 
        : $caption . "\n\n" . $additional;
}

function sendMessage($chat_id, $text, $reply_markup = null) {
    global $api;
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($reply_markup) {
        $data['reply_markup'] = $reply_markup;
    }
    return file_get_contents($api . "sendMessage?" . http_build_query($data));
}

function sendFile($chat_id, $file_type, $file_id, $caption) {
    global $api, $config;
    
    if (empty($caption) && $config['file_signature_enabled']) {
        $caption = $config['signature'];
    } else {
    $caption = replaceUsername($caption);
    }

    $caption = addAdditionalText($caption);

    $data = [
        'chat_id' => $chat_id,
        'caption' => $caption,
        'parse_mode' => 'HTML'
    ];
    $data[$file_type] = $file_id;

    return file_get_contents($api . "send" . ucfirst($file_type) . "?" . http_build_query($data));
}

// پردازش پیام‌ها
if (isset($update["message"])) {
    $message = $update["message"];
    $chat_id = $message["chat"]["id"];
    $user_id = $message["from"]["id"];
    $text = $message["text"] ?? "";

    // نمایش آیدی عددی برای اضافه کردن ادمین
    if ($text === "/myid") {
        sendMessage($chat_id, "🆔 آیدی عددی شما: " . $user_id);
        exit;
    }

    // دستورات ادمین
    if (isAdmin($user_id)) {
        if ($text === "/admin" || $text === "/start") {
            $keyboard = [
                'keyboard' => [
                    [['text' => '🔄 تغییر امضا'], ['text' => '📝 تنظیم متن اضافی']],
                    [['text' => '👥 مدیریت ادمین‌ها'], ['text' => '⚙️ تنظیمات']],
                    [['text' => '❌ بستن پنل مدیریت']]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => false
            ];
            sendMessage($chat_id, "🔧 به پنل مدیریت ربات خوش آمدید\n\n📝 امضای فعلی: {$config['signature']}\n👥 تعداد ادمین‌ها: " . count($admin_ids) . "\n\n💬 متن اضافی: " . ($config['additional_text'] ?: "تنظیم نشده") . "\n📍 موقعیت متن اضافی: " . ($config['additional_text_position'] === 'before' ? "قبل از کپشن" : "بعد از کپشن"), json_encode($keyboard));
            exit;
        }
        
        if ($text === "🔄 تغییر امضا") {
            sendMessage($chat_id, "🔄 برای تغییر امضا از دستور زیر استفاده کنید:\n\n/setsignature نام_کاربری\n\nمثال:\n/setsignature filmHollywoodi");
            exit;
        }

        if ($text === "📝 تنظیم متن اضافی") {
            $keyboard = [
                'keyboard' => [
                    [['text' => '📍 تغییر موقعیت متن اضافی']],
                    [['text' => '❌ حذف متن اضافی']],
                    [['text' => '🔙 بازگشت به منوی اصلی']]
                ],
                'resize_keyboard' => true
            ];
            sendMessage($chat_id, "📝 برای تنظیم متن اضافی از دستور زیر استفاده کنید:\n\n/setadditional متن_موردنظر\n\nمتن فعلی:\n" . ($config['additional_text'] ?: "تنظیم نشده"), json_encode($keyboard));
            exit;
        }

        if ($text === "👥 مدیریت ادمین‌ها") {
            $admins_list = "👥 لیست ادمین‌ها:\n\n";
            foreach ($admin_ids as $admin_id) {
                $admins_list .= "• $admin_id\n";
            }
            $keyboard = [
                'keyboard' => [
                    [['text' => '➕ افزودن ادمین'], ['text' => '➖ حذف ادمین']],
                    [['text' => '🔙 بازگشت به منوی اصلی']]
                ],
                'resize_keyboard' => true
            ];
            $admins_list .= "\n📝 راهنمای دستورات:\n/addadmin آیدی_عددی\n/deladmin آیدی_عددی";
            sendMessage($chat_id, $admins_list, json_encode($keyboard));
            exit;
        }

        if ($text === "⚙️ تنظیمات") {
            $keyboard = [
                'keyboard' => [
                    [['text' => ($config['file_signature_enabled'] ? '✅' : '❌') . ' امضای خودکار فایل‌ها']],
                    [['text' => '🔙 بازگشت به منوی اصلی']]
                ],
                'resize_keyboard' => true
            ];
            sendMessage($chat_id, "⚙️ تنظیمات ربات:", json_encode($keyboard));
            exit;
        }

        if ($text === "❌ بستن پنل مدیریت") {
            $remove_keyboard = ['remove_keyboard' => true];
            sendMessage($chat_id, "✅ پنل مدیریت بسته شد.", json_encode($remove_keyboard));
            exit;
        }

        if ($text === "🔙 بازگشت به منوی اصلی") {
            $keyboard = [
                'keyboard' => [
                    [['text' => '🔄 تغییر امضا'], ['text' => '📝 تنظیم متن اضافی']],
                    [['text' => '👥 مدیریت ادمین‌ها'], ['text' => '⚙️ تنظیمات']],
                    [['text' => '❌ بستن پنل مدیریت']]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => false
            ];
            sendMessage($chat_id, "🔧 به پنل مدیریت ربات خوش آمدید\n\n📝 امضای فعلی: {$config['signature']}\n👥 تعداد ادمین‌ها: " . count($admin_ids) . "\n\n💬 متن اضافی: " . ($config['additional_text'] ?: "تنظیم نشده") . "\n📍 موقعیت متن اضافی: " . ($config['additional_text_position'] === 'before' ? "قبل از کپشن" : "بعد از کپشن"), json_encode($keyboard));
            exit;
        }

        if ($text === "📍 تغییر موقعیت متن اضافی") {
            $old_position = $config['additional_text_position'];
            $config['additional_text_position'] = $old_position === 'before' ? 'after' : 'before';
            saveConfig();
            $position_text = $config['additional_text_position'] === 'before' ? "قبل از کپشن" : "بعد از کپشن";
            sendMessage($chat_id, "✅ موقعیت متن اضافی به «$position_text» تغییر کرد.");
            exit;
        }

        if ($text === "❌ حذف متن اضافی") {
            $config['additional_text'] = '';
            saveConfig();
            sendMessage($chat_id, "✅ متن اضافی حذف شد.");
            exit;
        }
        
        if (strpos($text, "/setsignature ") === 0) {
            $new_signature = substr($text, 13);
            $new_signature = trim($new_signature); // حذف فاصله‌های اضافی
            if (strpos($new_signature, '@') !== 0) {
                $new_signature = '@' . $new_signature;
            }
            // حذف فاصله‌های احتمالی بین @ و نام کاربری
            $new_signature = preg_replace('/@\s+/', '@', $new_signature);
            $config['signature'] = $new_signature;
            saveConfig();
            sendMessage($chat_id, "✅ امضای جدید با موفقیت تنظیم شد:\n{$new_signature}");
            exit;
        }

        if (strpos($text, "/setadditional ") === 0) {
            $new_text = substr($text, 14);
            $config['additional_text'] = $new_text;
            saveConfig();
            sendMessage($chat_id, "✅ متن اضافی با موفقیت تنظیم شد:\n\n$new_text");
            exit;
        }

        if (strpos($text, "/addadmin ") === 0) {
            $new_admin_id = (int)substr($text, 10);
            if (!in_array($new_admin_id, $admin_ids)) {
                $admin_ids[] = $new_admin_id;
                $config['admin_ids'] = $admin_ids;
                saveConfig();
                sendMessage($chat_id, "✅ ادمین جدید با آیدی $new_admin_id اضافه شد.");
            } else {
                sendMessage($chat_id, "⚠️ این کاربر قبلاً ادمین است.");
            }
            exit;
        }

        if (strpos($text, "/deladmin ") === 0) {
            $admin_id = (int)substr($text, 10);
            if (($key = array_search($admin_id, $admin_ids)) !== false) {
                unset($admin_ids[$key]);
                $config['admin_ids'] = array_values($admin_ids);
                saveConfig();
                sendMessage($chat_id, "✅ ادمین با آیدی $admin_id حذف شد.");
            } else {
                sendMessage($chat_id, "⚠️ این کاربر ادمین نیست.");
            }
            exit;
        }

        if ($text === "✅ امضای خودکار فایل‌ها" || $text === "❌ امضای خودکار فایل‌ها") {
            $config['file_signature_enabled'] = !$config['file_signature_enabled'];
            saveConfig();
            $status = $config['file_signature_enabled'] ? "فعال" : "غیرفعال";
            sendMessage($chat_id, "✅ امضای خودکار فایل‌ها $status شد.");
            exit;
        }
    } else if ($text === "/admin") {
        sendMessage($chat_id, "⚠️ شما دسترسی ادمین ندارید.\n\nبرای دریافت آیدی عددی خود از دستور /myid استفاده کنید و به ادمین اصلی بدهید.");
        exit;
    }

    // پردازش فایل‌ها
    if (isset($message["video"])) {
        sendFile($chat_id, "video", $message["video"]["file_id"], $message["caption"]);
    } elseif (isset($message["photo"])) {
        $photo = end($message["photo"]);
        sendFile($chat_id, "photo", $photo["file_id"], $message["caption"]);
    } elseif (isset($message["document"])) {
        sendFile($chat_id, "document", $message["document"]["file_id"], $message["caption"]);
} else {
        sendMessage($chat_id, "📤 فقط فایل با کپشن بفرست :)");
    }
}
?>
