<?php
// اسکریپت پاک کردن فایل‌های تکراری از پوشه‌ها
include_once "config.php";

$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);

if (!$db) {
    die("خطا در اتصال به دیتابیس: " . mysqli_connect_error());
}

echo "<h2>🔧 پاک کردن فایل‌های تکراری از پوشه‌ها</h2>";

// یافتن تکرارها
$duplicates_sql = "
SELECT folder_id, file_id, COUNT(*) as count 
FROM folder_files 
GROUP BY folder_id, file_id 
HAVING COUNT(*) > 1
";

$duplicates_result = mysqli_query($db, $duplicates_sql);

if (mysqli_num_rows($duplicates_result) > 0) {
    echo "<h3>📋 فایل‌های تکراری یافت شده:</h3>";
    
    while ($duplicate = mysqli_fetch_assoc($duplicates_result)) {
        $folder_id = $duplicate['folder_id'];
        $file_id = $duplicate['file_id'];
        $count = $duplicate['count'];
        
        // گرفتن نام پوشه
        $folder_name_sql = mysqli_query($db, "SELECT name FROM folders WHERE id = '$folder_id'");
        $folder_name = mysqli_fetch_assoc($folder_name_sql)['name'] ?? 'نامشخص';
        
        echo "<p>پوشه: <strong>$folder_name</strong> - فایل: <strong>$file_id</strong> - تعداد: <strong>$count</strong></p>";
        
        // حذف همه رکوردهای تکراری و نگه داشتن فقط یکی
        $delete_sql = "
        DELETE FROM folder_files 
        WHERE folder_id = '$folder_id' AND file_id = '$file_id' 
        AND id NOT IN (
            SELECT * FROM (
                SELECT MIN(id) 
                FROM folder_files 
                WHERE folder_id = '$folder_id' AND file_id = '$file_id'
            ) as temp
        )";
        
        if (mysqli_query($db, $delete_sql)) {
            $deleted_rows = mysqli_affected_rows($db);
            echo "<p style='color: green;'>✅ $deleted_rows رکورد تکراری پاک شد</p>";
        } else {
            echo "<p style='color: red;'>❌ خطا در پاک کردن: " . mysqli_error($db) . "</p>";
        }
    }
    
    echo "<h3>🎉 تمیزکاری کامل شد!</h3>";
} else {
    echo "<p style='color: blue;'>ℹ️ هیچ فایل تکراری یافت نشد.</p>";
}

// اضافه کردن ایندکس برای جلوگیری از تکرار آینده
$add_unique_index = "ALTER TABLE folder_files ADD UNIQUE INDEX unique_folder_file (folder_id, file_id)";
$index_result = mysqli_query($db, $add_unique_index);

if ($index_result) {
    echo "<p style='color: green;'>✅ ایندکس منحصربه‌فرد اضافه شد - تکرار آینده جلوگیری می‌شود</p>";
} else {
    if (strpos(mysqli_error($db), 'Duplicate key name') !== false) {
        echo "<p style='color: blue;'>ℹ️ ایندکس منحصربه‌فرد از قبل موجود است</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ خطا در اضافه کردن ایندکس: " . mysqli_error($db) . "</p>";
    }
}

echo "<p><a href='bot.php'>🔙 بازگشت به ربات</a></p>";

mysqli_close($db);
?> 