<?php
// فایل بررسی سلامت ربات
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once "config.php";

echo "<h2>🔍 بررسی سلامت ربات</h2>";

// بررسی ورژن PHP
echo "<h3>📱 ورژن PHP:</h3>";
echo "ورژن فعلی: " . PHP_VERSION . "<br>";
if (version_compare(PHP_VERSION, '7.4.0', '>=')) {
    echo "✅ ورژن PHP سازگار است<br>";
} else {
    echo "❌ ورژن PHP قدیمی است. حداقل 7.4 مورد نیاز است<br>";
}

// بررسی اتصال پایگاه داده
echo "<h3>🗄️ بررسی پایگاه داده:</h3>";
$db = new mysqli('localhost', $databaseUser, $databasePass, $databaseName);
if ($db->connect_error) {
    echo "❌ خطا در اتصال به پایگاه داده: " . $db->connect_error . "<br>";
} else {
    echo "✅ اتصال به پایگاه داده موفق<br>";
    $db->set_charset('utf8mb4');
    
    // بررسی جداول مورد نیاز
    $required_tables = ['user', 'file', 'lock', 'settings'];
    foreach ($required_tables as $table) {
        $result = $db->query("SHOW TABLES LIKE '$table'");
        if ($result && $result->num_rows > 0) {
            echo "✅ جدول $table موجود است<br>";
        } else {
            echo "❌ جدول $table موجود نیست<br>";
        }
    }
}

// بررسی API ربات
echo "<h3>🤖 بررسی API ربات:</h3>";
function testBotAPI($token) {
    $url = "https://api.telegram.org/bot$token/getMe";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode == 200) {
        $data = json_decode($response, true);
        if ($data['ok']) {
            return $data['result'];
        }
    }
    return false;
}

$botInfo = testBotAPI($token);
if ($botInfo) {
    echo "✅ ربات فعال است<br>";
    echo "نام ربات: " . $botInfo['first_name'] . "<br>";
    echo "نام کاربری: @" . $botInfo['username'] . "<br>";
} else {
    echo "❌ ربات در دسترس نیست یا توکن نامعتبر است<br>";
}

// بررسی دسترسی‌های فایل
echo "<h3>📁 بررسی دسترسی‌های فایل:</h3>";
$directories = ['Data', 'res'];
foreach ($directories as $dir) {
    if (is_dir($dir)) {
        if (is_writable($dir)) {
            echo "✅ دایرکتوری $dir قابل نوشتن است<br>";
        } else {
            echo "⚠️ دایرکتوری $dir قابل نوشتن نیست<br>";
        }
    } else {
        if (mkdir($dir, 0755, true)) {
            echo "✅ دایرکتوری $dir ایجاد شد<br>";
        } else {
            echo "❌ نمی‌توان دایرکتوری $dir را ایجاد کرد<br>";
        }
    }
}

// بررسی فایل‌های مورد نیاز
$required_files = ['bot.php', 'config.php'];
foreach ($required_files as $file) {
    if (file_exists($file)) {
        echo "✅ فایل $file موجود است<br>";
    } else {
        echo "❌ فایل $file موجود نیست<br>";
    }
}

echo "<h3>📊 نتیجه:</h3>";
echo "اگر همه موارد ✅ هستند، ربات آماده استفاده است!<br>";
echo "در صورت وجود ❌، مشکلات را برطرف کنید.<br>";

// بستن اتصال
if (isset($db) && $db) {
    $db->close();
}
?> 