<?php
/**
 * پیدا کردن Type های صحیح API اینستاگرام
 * 
 * این فایل تمام type های ممکن را تست می‌کند
 */

require_once 'config.php';

$username = isset($_GET['username']) ? $_GET['username'] : 'instagram';
$url = isset($_GET['url']) ? $_GET['url'] : 'https://www.instagram.com/p/example/';

// لیست type های ممکن برای تست
$userTypes = ['user', 'info', 'profile', 'userinfo', 'get_user', 'account'];
$postTypes = ['post', 'media', 'get_post', 'download'];
$reelTypes = ['reel', 'post', 'media', 'video'];

function testType($type, $params) {
    $apiParams = [
        'apikey' => INSTAGRAM_API_KEY,
        'type' => $type
    ];
    
    $apiParams = array_merge($apiParams, $params);
    $url = INSTAGRAM_API_URL . '?' . http_build_query($apiParams);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $result = json_decode($response, true);
    
    return [
        'type' => $type,
        'http_code' => $httpCode,
        'response' => $result,
        'success' => isset($result['ok']) && $result['ok'] === true
    ];
}

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>پیدا کردن Type های صحیح API</title>
    <style>
        body { font-family: Tahoma; padding: 20px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 10px; max-width: 1400px; margin: 0 auto; }
        h1 { color: #333; border-bottom: 3px solid #4CAF50; padding-bottom: 10px; }
        .test-result { margin: 20px 0; padding: 15px; border-radius: 8px; }
        .success { background: #e8f5e9; border: 2px solid #4CAF50; }
        .failed { background: #ffebee; border: 2px solid #f44336; }
        .type-name { font-size: 18px; font-weight: bold; margin-bottom: 10px; }
        pre { background: #f5f5f5; padding: 10px; border-radius: 5px; overflow-x: auto; font-size: 12px; }
        .badge { padding: 5px 10px; border-radius: 5px; color: white; font-size: 12px; }
        .badge-success { background: #4CAF50; }
        .badge-error { background: #f44336; }
        .summary { background: #e3f2fd; padding: 20px; border-radius: 8px; margin: 20px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 پیدا کردن Type های صحیح API</h1>
        
        <?php if (isset($_GET['test'])): ?>
            
            <?php if ($_GET['test'] === 'user'): ?>
                <h2>👤 تست اطلاعات کاربر: @<?php echo htmlspecialchars($username); ?></h2>
                
                <?php
                $successfulTypes = [];
                
                foreach ($userTypes as $type) {
                    $result = testType($type, ['username' => $username]);
                    $class = $result['success'] ? 'success' : 'failed';
                    
                    if ($result['success']) {
                        $successfulTypes[] = $type;
                    }
                    
                    echo "<div class='test-result $class'>";
                    echo "<div class='type-name'>";
                    echo "Type: <code>$type</code> ";
                    echo $result['success'] ? "<span class='badge badge-success'>✅ موفق</span>" : "<span class='badge badge-error'>❌ ناموفق</span>";
                    echo "</div>";
                    echo "<pre>" . htmlspecialchars(json_encode($result['response'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) . "</pre>";
                    echo "</div>";
                }
                
                if (!empty($successfulTypes)) {
                    echo "<div class='summary'>";
                    echo "<h3>✅ Type های موفق:</h3>";
                    echo "<ul>";
                    foreach ($successfulTypes as $type) {
                        echo "<li><code>$type</code></li>";
                    }
                    echo "</ul>";
                    echo "<p><strong>توصیه:</strong> از <code>" . $successfulTypes[0] . "</code> استفاده کنید.</p>";
                    echo "</div>";
                }
                ?>
                
            <?php elseif ($_GET['test'] === 'post'): ?>
                <h2>📥 تست دانلود پست/ریل</h2>
                <p>URL: <?php echo htmlspecialchars($url); ?></p>
                
                <?php
                $successfulTypes = [];
                
                foreach ($postTypes as $type) {
                    $result = testType($type, ['url' => $url]);
                    $class = $result['success'] ? 'success' : 'failed';
                    
                    if ($result['success']) {
                        $successfulTypes[] = $type;
                    }
                    
                    echo "<div class='test-result $class'>";
                    echo "<div class='type-name'>";
                    echo "Type: <code>$type</code> ";
                    echo $result['success'] ? "<span class='badge badge-success'>✅ موفق</span>" : "<span class='badge badge-error'>❌ ناموفق</span>";
                    echo "</div>";
                    echo "<pre>" . htmlspecialchars(json_encode($result['response'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) . "</pre>";
                    echo "</div>";
                }
                
                if (!empty($successfulTypes)) {
                    echo "<div class='summary'>";
                    echo "<h3>✅ Type های موفق:</h3>";
                    echo "<ul>";
                    foreach ($successfulTypes as $type) {
                        echo "<li><code>$type</code></li>";
                    }
                    echo "</ul>";
                    echo "<p><strong>توصیه:</strong> از <code>" . $successfulTypes[0] . "</code> استفاده کنید.</p>";
                    echo "</div>";
                }
                ?>
                
            <?php endif; ?>
            
            <hr>
            <a href="find_correct_types.php"><button style="padding:10px 20px;background:#2196F3;color:white;border:none;border-radius:5px;cursor:pointer;">🔙 بازگشت</button></a>
            
        <?php else: ?>
            
            <div class="summary">
                <h3>📌 هدف این تست:</h3>
                <p>پیدا کردن type های صحیح برای API fast-creat.ir</p>
                <p>این فایل تمام type های ممکن را امتحان می‌کند و موفق‌ترین را پیشنهاد می‌دهد.</p>
            </div>
            
            <h2>انتخاب نوع تست:</h2>
            
            <div style="margin: 20px 0;">
                <h3>1️⃣ تست اطلاعات کاربر</h3>
                <form method="GET" style="margin: 10px 0;">
                    <input type="hidden" name="test" value="user">
                    <label>نام کاربری:</label><br>
                    <input type="text" name="username" value="instagram" style="padding: 8px; width: 300px; margin: 5px 0;">
                    <button type="submit" style="padding: 8px 20px; background: #4CAF50; color: white; border: none; border-radius: 5px; cursor: pointer;">🧪 تست کن</button>
                </form>
                <p><em>تست می‌کند: user, info, profile, userinfo, get_user, account</em></p>
            </div>
            
            <div style="margin: 20px 0;">
                <h3>2️⃣ تست دانلود پست/ریل</h3>
                <form method="GET" style="margin: 10px 0;">
                    <input type="hidden" name="test" value="post">
                    <label>لینک پست/ریل:</label><br>
                    <input type="text" name="url" placeholder="https://www.instagram.com/p/... یا .../reel/..." style="padding: 8px; width: 500px; margin: 5px 0;">
                    <button type="submit" style="padding: 8px 20px; background: #4CAF50; color: white; border: none; border-radius: 5px; cursor: pointer;">🧪 تست کن</button>
                </form>
                <p><em>تست می‌کند: post, media, get_post, download</em></p>
            </div>
            
        <?php endif; ?>
        
    </div>
</body>
</html> 