<?php
/**
 * دیباگ دقیق API استوری
 */

require_once 'config.php';
require_once 'functions.php';

// لینک‌های تستی که کاربر فرستاده
$testLinks = [
    'https://www.instagram.com/s/aGlnaGxpZ2h0OjE3OTgwMTc5MDQ2NjgzODc4?story_media_id=2956508569652725487_8736481899&igsh=Z2k3MDMyZXM1YWNn',
    'https://www.instagram.com/stories/pistoncupproductions/3741270097814743417?utm_source=ig_story_item_share&igsh=MzFoMHNlZ3k3aHIx'
];

echo "=== دیباگ دقیق API استوری ===\n\n";

foreach ($testLinks as $index => $link) {
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "تست " . ($index + 1) . ":\n";
    echo "لینک: " . $link . "\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // فراخوانی API
    $result = getStoryFromFastCreatAPI($link);
    
    echo "📊 وضعیت: " . ($result['success'] ? "✅ موفق" : "❌ خطا") . "\n\n";
    
    if ($result['success']) {
        $data = $result['data'];
        
        echo "📦 پاسخ کامل API:\n";
        echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n\n";
        
        // تحلیل ساختار
        echo "🔍 تحلیل ساختار:\n";
        
        // فرمت 1: {ok: true, result: {status: "success", result: [...]}}
        if (isset($data['ok']) && $data['ok'] === true && isset($data['result']['result'])) {
            echo "  ✓ فرمت: {ok: true, result: {result: [...]}}\n";
            $items = is_array($data['result']['result']) ? $data['result']['result'] : [$data['result']['result']];
            echo "  ✓ تعداد آیتم‌ها: " . count($items) . "\n\n";
        }
        // فرمت 2: {status: "successfully", result: {result: [...]}}
        elseif (isset($data['status']) && $data['status'] === 'successfully' && isset($data['result']['result'])) {
            echo "  ✓ فرمت: {status: 'successfully', result: {result: [...]}}\n";
            $items = is_array($data['result']['result']) ? $data['result']['result'] : [$data['result']['result']];
            echo "  ✓ تعداد آیتم‌ها: " . count($items) . "\n\n";
        }
        // فرمت 3: {status: "success", data: {...}}
        elseif (isset($data['status']) && $data['status'] === 'success' && isset($data['data'])) {
            echo "  ✓ فرمت: {status: 'success', data: {...}}\n";
            $items = [$data['data']];
            echo "  ✓ تعداد آیتم‌ها: " . count($items) . "\n\n";
        }
        // فرمت پیش‌فرض
        else {
            echo "  ⚠️ فرمت: نامشخص (استفاده از پیش‌فرض)\n";
            $items = [$data];
            echo "  ✓ تعداد آیتم‌ها: " . count($items) . "\n\n";
        }
        
        // بررسی آیتم‌ها
        echo "📸 بررسی آیتم‌ها:\n";
        foreach ($items as $itemIndex => $item) {
            echo "\n  آیتم " . ($itemIndex + 1) . ":\n";
            echo "  ───────────────────────\n";
            
            if (is_array($item)) {
                echo "  کلیدهای موجود: " . implode(', ', array_keys($item)) . "\n\n";
                
                // بررسی انواع URL
                $foundUrls = [];
                
                // فرمت fast-creat.ir
                if (isset($item['url'])) {
                    $foundUrls[] = "url: " . substr($item['url'], 0, 60) . "...";
                }
                if (isset($item['type'])) {
                    $foundUrls[] = "type: " . $item['type'];
                }
                
                // فرمت‌های قدیمی
                if (isset($item['video_url'])) {
                    $foundUrls[] = "video_url: " . substr($item['video_url'], 0, 60) . "...";
                }
                if (isset($item['image_url'])) {
                    $foundUrls[] = "image_url: " . substr($item['image_url'], 0, 60) . "...";
                }
                if (isset($item['display_url'])) {
                    $foundUrls[] = "display_url: " . substr($item['display_url'], 0, 60) . "...";
                }
                if (isset($item['is_video'])) {
                    $foundUrls[] = "is_video: " . ($item['is_video'] ? 'true' : 'false');
                }
                
                if (!empty($foundUrls)) {
                    echo "  ✅ URL های یافت شده:\n";
                    foreach ($foundUrls as $url) {
                        echo "     • " . $url . "\n";
                    }
                } else {
                    echo "  ❌ هیچ URL معتبری یافت نشد!\n";
                    echo "  محتوای آیتم:\n";
                    echo "  " . json_encode($item, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
                }
            } else {
                echo "  ❌ آیتم آرایه نیست!\n";
                echo "  نوع: " . gettype($item) . "\n";
                echo "  محتوا: " . json_encode($item, JSON_UNESCAPED_UNICODE) . "\n";
            }
        }
        
    } else {
        echo "❌ خطا در فراخوانی API\n";
        echo "پیام خطا: " . ($result['error'] ?? 'نامشخص') . "\n";
        if (isset($result['data'])) {
            echo "\nداده‌های خطا:\n";
            echo json_encode($result['data'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
        }
    }
    
    echo "\n\n";
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "تست تمام شد!\n\n";

echo "💡 راهنما:\n";
echo "  • اگر 'تعداد آیتم‌ها' صفر است، API هیچ استوری‌ای برنمی‌گرداند\n";
echo "  • اگر 'هیچ URL معتبری یافت نشد'، ساختار پاسخ با کد ما تطابق ندارد\n";
echo "  • باید فرمت صحیح را شناسایی و کد را تطبیق دهیم\n";


