# راهنمای نصب نهایی ربات v2

## ✅ ربات شما آماده است!

### مشکل فعلی:
شما **دو ربات** دارید که هر دو فعال هستند:
1. ربات قدیمی: `index.php` (در پوشه اصلی)
2. ربات جدید v2: `bot-v2/index.php`

این باعث میشه که دستورات دوبار اجرا بشن!

## 🔧 راه حل:

### گزینه 1: غیرفعال کردن ربات قدیمی (توصیه میشه)

1. فایل `index.php` اصلی رو تغییر نام بده:
   ```
   index.php -> index.php.old
   ```

2. یا محتوای `index.php` رو پاک کن و این کد رو بذار:
   ```php
   <?php
   // Redirect to new bot
   header('Location: bot-v2/index.php');
   exit;
   ```

### گزینه 2: استفاده از Webhook جداگانه

اگر میخوای هر دو ربات رو نگه داری:

1. برای ربات قدیمی یه توکن جدید بگیر
2. Webhook ربات اصلی رو به `index.php` بده
3. Webhook ربات جدید رو به `bot-v2/index.php` بده

## 📋 چک لیست نهایی:

- [ ] Webhook درست ست شده: `https://yourdomain.com/bot-v2/index.php`
- [ ] ربات قدیمی غیرفعال شده
- [ ] توکن ربات در `bot-v2/config.php` درست است
- [ ] اطلاعات دیتابیس در `bot-v2/config.php` درست است
- [ ] آیدی ادمین در `bot-v2/config.php` درست است
- [ ] DEBUG_MODE خاموش است
- [ ] فایل‌های تست حذف شدن

## 🧪 تست نهایی:

### 1. تست پرایوت:
```
/start
```
باید پنل ادمین یا پیام خوشامدگویی نشون بده.

### 2. تست گروه:
```
/start
```
باید ربات نصب بشه و پیام تأیید بده.

```
/panel
```
باید پنل مدیریتی نشون بده (فقط یک بار!)

### 3. تست دکمه‌ها:
- دکمه‌های معمولی (آمار، راهنما، ...)
- دکمه‌های شیشه‌ای (Inline)

## 🎯 قابلیت‌های فعال:

✅ **پرایوت:**
- پنل ادمین کامل
- مدیریت اشتراک
- چت با AI (اگر API Key داشته باشی)
- سیستم پلاگین

✅ **گروه:**
- نصب و راه‌اندازی
- پنل مدیریتی
- قفل‌ها
- مدیریت کاربران

## ⚙️ تنظیمات اضافی:

### فعال کردن AI:
در `config.php`:
```php
define('GEMINI_API_KEY', 'YOUR_API_KEY');
define('AI_ENABLED', true);
```

### فعال کردن حالت اشتراکی:
در `config.php`:
```php
define('SUBSCRIPTION_REQUIRED', true);
define('FREE_TRIAL_DAYS', 7);
```

### اضافه کردن ادمین:
در `config.php`:
```php
define('ADMIN_IDS', [123456789, 987654321]);
```

## 🔒 امنیت:

1. ✅ فایل‌های تست حذف شدن
2. ✅ DEBUG_MODE خاموش شد
3. ⚠️ `view_logs.php` رو بعد از تست حذف کن یا محافظت کن
4. ⚠️ توکن ربات رو محرمانه نگه دار

## 📞 پشتیبانی:

اگر مشکلی داشتی:
1. لاگ‌ها رو چک کن: `bot-v2/logs/`
2. Webhook رو چک کن
3. اطلاعات config رو دوباره بررسی کن

---

**نکته مهم:** بعد از غیرفعال کردن ربات قدیمی، حتماً ربات رو دوباره تست کن!
