# 🤖 ربات مدیریت گروه تلگرام - نسخه 2.0

ربات پیشرفته و بهینه شده برای مدیریت گروه‌های تلگرام با PHP 7.4+

## ✨ ویژگی‌های نسخه 2.0

### 🔥 بهبودهای اصلی نسبت به نسخه قبل:

1. **معماری OOP کامل** - کد تمیز و قابل نگهداری
2. **امنیت بالا** - استفاده از Prepared Statements
3. **Type Declarations** - استفاده از PHP 7.4 type hints
4. **Error Handling** - مدیریت حرفه‌ای خطاها
5. **Logging System** - ثبت تمام خطاها و رویدادها
6. **Singleton Pattern** - مدیریت بهینه منابع
7. **کد تمیز و خوانا** - استانداردهای PSR
8. **Performance** - بهینه‌سازی کوئری‌ها و کش

---

## 📋 پیش‌نیازها

- PHP 7.4 یا بالاتر
- MySQL 5.7 یا بالاتر / MariaDB 10.2+
- Extension های PHP:
  - mysqli
  - curl
  - json
  - mbstring
- دسترسی به cron job (برای ارسال همگانی و حذف خودکار)

---

## 🚀 نصب و راه‌اندازی

### مرحله 1: آپلود فایل‌ها

تمام فایل‌های پوشه `bot-v2` را در سرور خود آپلود کنید.

### مرحله 2: تنظیم دیتابیس

1. یک دیتابیس MySQL جدید بسازید
2. فایل `config.php` را باز کنید
3. اطلاعات دیتابیس را وارد کنید:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_password');
define('DB_NAME', 'your_db_name');
```

### مرحله 3: تنظیم ربات

در فایل `config.php`:

```php
// توکن ربات از @BotFather
define('BOT_TOKEN', 'YOUR_BOT_TOKEN');

// یوزرنیم ربات (بدون @)
define('BOT_USERNAME', 'YourBotUsername');

// آیدی ادمین‌ها
define('ADMIN_IDS', [123456789, 987654321]);

// کانال پشتیبانی
define('SUPPORT_CHANNEL', '@YourChannel');
define('SUPPORT_GROUP', 'https://t.me/joinchat/XXXXX');
```

### مرحله 4: تنظیم Webhook

دستور زیر را در مرورگر اجرا کنید:

```
https://api.telegram.org/botYOUR_BOT_TOKEN/setWebhook?url=https://yourdomain.com/bot-v2/index.php
```

یا از این کد PHP استفاده کنید:

```php
<?php
$token = "YOUR_BOT_TOKEN";
$webhookUrl = "https://yourdomain.com/bot-v2/index.php";

$result = file_get_contents("https://api.telegram.org/bot{$token}/setWebhook?url={$webhookUrl}");
echo $result;
```

### مرحله 5: تنظیم Cron Jobs (اختیاری)

برای ارسال همگانی و حذف خودکار پیام‌ها:

```bash
# هر 1 دقیقه - حذف خودکار پیام‌ها
* * * * * php /path/to/bot-v2/cron/delete_messages.php

# هر 1 دقیقه - ارسال همگانی
* * * * * php /path/to/bot-v2/cron/send_all.php
```

---

## 📁 ساختار پروژه

```
bot-v2/
├── config.php              # تنظیمات اصلی
├── index.php               # نقطه ورود (webhook)
├── Database.php            # کلاس دیتابیس
├── Telegram.php            # کلاس API تلگرام
├── Bot.php                 # کلاس اصلی ربات
├── handlers/               # هندلرهای مختلف
│   ├── PrivateChat.php     # مدیریت چت خصوصی
│   ├── GroupManager.php    # مدیریت گروه
│   └── AdminPanel.php      # پنل ادمین
├── cron/                   # فایل‌های cron
│   ├── delete_messages.php
│   └── send_all.php
├── data/                   # فایل‌های داده
├── logs/                   # لاگ‌ها
├── cache/                  # کش
└── README.md               # این فایل
```

---

## 🎯 قابلیت‌های ربات

### 👥 مدیریت کاربران
- ✅ ترفیع و عزل مدیران
- ✅ کاربران ویژه (VIP)
- ✅ سیستم اخطار (Warn)
- ✅ بن و آنبن
- ✅ سکوت (موقت و دائم)
- ✅ اخراج از گروه

### 🔒 سیستم قفل‌ها
- ✅ قفل لینک، فوروارد، تگ، هشتگ
- ✅ قفل فارسی، انگلیسی، ایموجی
- ✅ قفل عکس، فیلم، ویس، استیکر، گیف
- ✅ قفل ربات‌ها و عضو جدید
- ✅ قفل سختگیرانه
- ✅ قفل خودکار زمان‌دار

### 🛡️ امنیت
- ✅ ضد رگبار (Anti Flood)
- ✅ ضد تبچی (Anti Tabchi)
- ✅ احراز هویت (Captcha)
- ✅ عضویت اجباری کانال
- ✅ اد اجباری

### 💬 تعامل
- ✅ خوشامدگویی سفارشی
- ✅ فیلتر کلمات
- ✅ پاسخ خودکار
- ✅ تنظیم لقب کاربران

### 📊 آمار و گزارش
- ✅ آمار روزانه گروه
- ✅ فعال‌ترین اعضا
- ✅ آمار کلی ربات

### 🎮 سرگرمی
- ✅ فال حافظ
- ✅ تقویم شمسی
- ✅ هواشناسی
- ✅ ترجمه
- ✅ معنی کلمات

### ⚙️ مدیریت
- ✅ پنل اینلاین
- ✅ حذف دسته‌جمعی پیام‌ها
- ✅ سنجاق و حذف سنجاق
- ✅ تنظیم قوانین و لینک
- ✅ ارسال همگانی

---

## 🔧 تنظیمات پیشرفته

### فعال کردن Debug Mode

در `config.php`:

```php
define('DEBUG_MODE', true);
```

⚠️ **هشدار:** Debug mode را فقط در محیط توسعه فعال کنید!

### تغییر حداکثر گروه‌ها

```php
define('MAX_GROUPS', 1000);
```

### تغییر منطقه زمانی

```php
define('TIMEZONE', 'Asia/Tehran');
```

---

## 📝 لاگ‌ها

تمام خطاها و رویدادها در پوشه `logs/` ذخیره می‌شوند:

- `db_errors_YYYY-MM-DD.log` - خطاهای دیتابیس
- `telegram_errors_YYYY-MM-DD.log` - خطاهای API تلگرام
- `bot_errors_YYYY-MM-DD.log` - خطاهای عمومی

---

## 🔐 امنیت

### نکات امنیتی مهم:

1. ✅ **هرگز توکن ربات را به اشتراک نگذارید**
2. ✅ **فایل config.php را از دسترس عمومی خارج کنید**
3. ✅ **از HTTPS برای webhook استفاده کنید**
4. ✅ **رمز دیتابیس قوی انتخاب کنید**
5. ✅ **به‌روزرسانی منظم PHP و MySQL**
6. ✅ **Backup منظم از دیتابیس**

### محافظت از config.php

در فایل `.htaccess`:

```apache
<Files "config.php">
    Order Allow,Deny
    Deny from all
</Files>
```

---

## 🐛 عیب‌یابی

### ربات پاسخ نمیدهد

1. Webhook را چک کنید:
```
https://api.telegram.org/botYOUR_TOKEN/getWebhookInfo
```

2. لاگ‌های خطا را بررسی کنید
3. مجوزهای فایل‌ها را چک کنید (755 برای پوشه‌ها، 644 برای فایل‌ها)

### خطای دیتابیس

1. اطلاعات اتصال را چک کنید
2. مجوزهای کاربر دیتابیس را بررسی کنید
3. لاگ `db_errors_*.log` را بررسی کنید

---

## 📈 بهینه‌سازی

### برای گروه‌های بزرگ:

1. از Redis برای کش استفاده کنید
2. Index های دیتابیس را بهینه کنید
3. از CDN برای فایل‌های استاتیک استفاده کنید
4. Connection pooling را فعال کنید

---

## 🤝 مشارکت

برای گزارش باگ یا پیشنهاد ویژگی جدید:

- 📧 ایمیل: your@email.com
- 💬 تلگرام: @YourUsername
- 📢 کانال: @YourChannel

---

## 📜 لایسنس

این پروژه تحت لایسنس MIT منتشر شده است.

---

## 🙏 تشکر

از تمام کسانی که در توسعه این ربات مشارکت داشتند، تشکر می‌کنیم!

---

## 📞 پشتیبانی

برای دریافت پشتیبانی:

- 📢 کانال: " . SUPPORT_CHANNEL . "
- 💬 گروه: " . SUPPORT_GROUP . "

---

**نسخه:** 2.0  
**تاریخ:** 1404/08/05  
**توسعه‌دهنده:** Kiro AI Assistant

---

## ⭐ اگر این پروژه برایتان مفید بود، حمایت کنید!

```
به ما ستاره بدهید ⭐
در کانال عضو شوید 📢
به دوستان معرفی کنید 🔗
```
