<?php
/**
 * پاک کردن تمام Session های کاربران
 * 
 * این فایل را یک بار اجرا کنید تا تمام session های گیر کرده پاک شوند
 * سپس حتماً این فایل را حذف کنید!
 */

define('USER_SESSIONS_FILE', __DIR__ . '/user_sessions.json');

// پاک کردن تمام session ها
if (file_exists(USER_SESSIONS_FILE)) {
    $oldSessions = file_get_contents(USER_SESSIONS_FILE);
    
    // بکاپ session های قبلی
    $backupFile = __DIR__ . '/user_sessions_backup_' . date('Y-m-d_H-i-s') . '.json';
    file_put_contents($backupFile, $oldSessions);
    
    // پاک کردن session ها
    file_put_contents(USER_SESSIONS_FILE, '{}');
    
    echo "<!DOCTYPE html>";
    echo "<html lang='fa' dir='rtl'>";
    echo "<head><meta charset='UTF-8'><title>پاک کردن Session ها</title>";
    echo "<style>body{font-family:Tahoma;padding:50px;background:#f5f5f5;}";
    echo ".success{background:#4CAF50;color:white;padding:30px;border-radius:10px;text-align:center;font-size:20px;}";
    echo ".info{background:#2196F3;color:white;padding:20px;border-radius:10px;margin-top:20px;}";
    echo ".warning{background:#FF9800;color:white;padding:20px;border-radius:10px;margin-top:20px;}";
    echo "pre{background:white;padding:15px;border-radius:5px;overflow-x:auto;}</style></head><body>";
    
    echo "<div class='success'>";
    echo "✅ تمام Session ها با موفقیت پاک شدند!";
    echo "</div>";
    
    echo "<div class='info'>";
    echo "<h3>📊 اطلاعات:</h3>";
    echo "<p>✅ Session های قبلی در فایل زیر بکاپ شدند:</p>";
    echo "<pre>" . $backupFile . "</pre>";
    echo "<p>✅ فایل user_sessions.json پاک شد</p>";
    echo "</div>";
    
    echo "<div class='warning'>";
    echo "<h3>⚠️ نکات مهم:</h3>";
    echo "<p>1. حالا می‌توانید از ربات استفاده کنید</p>";
    echo "<p>2. لطفاً این فایل را <strong>حذف کنید</strong>: <code>clear_sessions.php</code></p>";
    echo "<p>3. دستور /panel یا /start را در ربات بزنید</p>";
    echo "</div>";
    
    echo "</body></html>";
    
} else {
    echo "<!DOCTYPE html>";
    echo "<html lang='fa' dir='rtl'><head><meta charset='UTF-8'><title>خطا</title></head><body>";
    echo "<h2 style='color:red;'>❌ فایل user_sessions.json یافت نشد!</h2>";
    echo "<p>لطفاً ابتدا فایل user_sessions.json را ایجاد کنید.</p>";
    echo "</body></html>";
} 