-- اسکریپت به‌روزرسانی دیتابیس برای افزودن قابلیت‌های جدید

-- 1. افزودن فیلد invite_link به جدول channels_required
ALTER TABLE channels_required 
ADD COLUMN IF NOT EXISTS invite_link TEXT AFTER channel_name;

-- 2. ایجاد جدول admins (در صورت عدم وجود)
CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    telegram_id BIGINT NOT NULL UNIQUE,
    username VARCHAR(255),
    first_name VARCHAR(255),
    last_name VARCHAR(255),
    added_by BIGINT,
    added_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    permissions VARCHAR(255) DEFAULT 'full',
    is_super_admin TINYINT(1) DEFAULT 0,
    INDEX (telegram_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3. افزودن فیلدهای is_forward و message_id به جدول broadcasts
ALTER TABLE broadcasts 
ADD COLUMN IF NOT EXISTS is_forward TINYINT(1) DEFAULT 0 AFTER completed_at,
ADD COLUMN IF NOT EXISTS message_id BIGINT DEFAULT NULL AFTER is_forward;

-- 4. به‌روزرسانی جدول users برای همگام‌سازی ادمین‌ها
UPDATE users u
INNER JOIN admins a ON u.telegram_id = a.telegram_id
SET u.is_admin = 1
WHERE u.is_admin = 0;

-- نمایش پیام موفقیت
SELECT 'دیتابیس با موفقیت به‌روزرسانی شد!' AS message; 