# 🤖 ربات محافظ لینک و آپلودر فایل تلگرام

این ربات یک سیستم کامل برای محافظت از لینک‌ها و آپلود فایل با جوین اجباری است.

## ✨ امکانات

### 📁 آپلود و اشتراک‌گذاری فایل
- **آپلود تکی**: ارسال یک فایل و دریافت لینک محافظت شده
- **آپلود گروهی**: ارسال چند فایل همزمان (media group) و دریافت یک لینک برای همه
- **حفظ کپشن**: کپشن‌های فایل‌ها حفظ و همراه فایل ارسال می‌شود
- **پشتیبانی از انواع فایل**: عکس، ویدیو، سند، صوت، ویس، انیمیشن، استیکر و...

### 🔗 محافظ لینک
- تبدیل هر لینکی به لینک محافظت شده با جوین اجباری
- ارسال لینک توسط ادمین و دریافت لینک محافظت شده

### 🔐 جوین اجباری
- اضافه کردن کانال‌های عمومی و خصوصی
- بررسی خودکار عضویت کاربر
- امکان تنظیم متن سفارشی جوین اجباری

### ⏱ حذف خودکار
- **حذف پیام‌های موقت**: پیام‌های محافظ لینک بعد از مدت تعیین شده حذف می‌شوند
- **حذف فایل‌ها**: فایل‌های ارسال شده به کاربر بعد از مدت تعیین شده حذف می‌شوند (قابل تنظیم جدا از پیام‌ها)

### 📊 پنل مدیریت حرفه‌ای
- آمار کامل کاربران، لینک‌ها، آپلودها و فایل‌ها
- مدیریت لینک‌ها و آپلودها با صفحه‌بندی
- ارسال و فوروارد همگانی با پیشرفت زنده
- مدیریت دکمه‌های سفارشی
- تنظیمات پیشرفته

## 🚀 نصب و راه‌اندازی

### 1. نیازمندی‌ها
- سرور با PHP 7.4 یا بالاتر
- توکن ربات تلگرام (از [@BotFather](https://t.me/BotFather))
- نام کاربری ربات (بدون @)

### 2. تنظیمات اولیه

1. فایل `config.php` را ویرایش کنید:
```php
define('BOT_TOKEN', 'توکن_ربات_شما');
define('BOT_USERNAME', 'نام_کاربری_ربات_بدون_@');
define('ADMIN_IDS', [شناسه_عددی_ادمین_1, شناسه_عددی_ادمین_2]);
```

2. وبهوک را تنظیم کنید:
```
https://api.telegram.org/bot<TOKEN>/setWebhook?url=https://domain.com/path/to/index.php
```

3. دسترسی‌های فایل را تنظیم کنید:
```bash
chmod 755 index.php functions.php config.php
chmod 777 *.json
```

### 3. تنظیم Cron (اختیاری برای ارسال همگانی)
```
* * * * * php /path/to/cron.php
```

## 📖 نحوه استفاده

### برای کاربران عادی

#### آپلود فایل
1. فایل خود را برای ربات ارسال کنید
2. لینک محافظت شده دریافت کنید
3. لینک را به اشتراک بگذارید

#### آپلود گروهی
1. چند فایل را همزمان انتخاب و ارسال کنید
2. یک لینک برای همه فایل‌ها دریافت کنید

### برای ادمین‌ها

#### محافظت لینک
1. هر لینکی را برای ربات ارسال کنید
2. لینک محافظت شده با جوین اجباری دریافت کنید

#### افزودن کانال عمومی
1. `/admin` → مدیریت کانال‌ها → افزودن کانال → کانال عمومی
2. نام نمایشی کانال را وارد کنید
3. username کانال را بدون @ وارد کنید

#### افزودن کانال خصوصی
1. `/admin` → مدیریت کانال‌ها → افزودن کانال → کانال خصوصی
2. نام کانال را وارد کنید
3. لینک دعوت کانال را ارسال کنید
4. یک پیام از کانال را فوروارد کنید
5. **مهم**: ربات باید Admin کانال باشد

#### تنظیم حذف خودکار فایل‌ها
1. `/admin` → تنظیمات → حذف خودکار فایل‌ها
2. زمان مورد نظر را انتخاب کنید (0 = خاموش)

## 🗂 ساختار فایل‌ها

```
mohafez_filimo/
├── index.php                    # فایل اصلی ربات
├── functions.php                # توابع کمکی
├── config.php                   # تنظیمات اولیه
├── cron.php                     # کرون برای ارسال همگانی
├── links.json                   # ذخیره لینک‌های محافظت شده
├── uploads.json                 # ذخیره آپلودها
├── users.json                   # ذخیره کاربران
├── channels.json                # ذخیره کانال‌های اجباری
├── states.json                  # ذخیره وضعیت‌های کاربر
├── media_groups.json            # مپ آپلودهای گروهی
├── auto_delete_settings.json   # تنظیمات حذف پیام‌ها
├── file_auto_delete_settings.json # تنظیمات حذف فایل‌ها
├── message_deletions.json       # صف حذف پیام‌ها
└── ...
```

## ⚙️ تنظیمات پیشرفته

### تنظیم زمان حذف خودکار پیام‌ها
- حداقل: 10 ثانیه
- حداکثر: 300 ثانیه (5 دقیقه)
- پیش‌فرض: 60 ثانیه

### تنظیم زمان حذف خودکار فایل‌ها
- حداقل: 0 (خاموش)
- حداکثر: 300 ثانیه (5 دقیقه)
- پیش‌فرض: 0 (خاموش)

## 🔧 عیب‌یابی

### ربات پاسخ نمی‌دهد
1. وبهوک را بررسی کنید: `getWebhookInfo`
2. لاگ‌های سرور را چک کنید
3. دسترسی‌های فایل را بررسی کنید

### فایل‌ها ارسال نمی‌شوند
1. سایز فایل باید زیر 50MB باشد (محدودیت Telegram Bot API)
2. file_id باید معتبر باشد
3. ربات باید به فایل دسترسی داشته باشد

### حذف خودکار کار نمی‌کند
1. Cron را تنظیم کنید
2. فایل `cron.php` را اجرا کنید
3. دسترسی‌ها را بررسی کنید

## 📝 نکات مهم

- **امنیت**: توکن ربات را محرمانه نگه دارید
- **بکاپ**: از فایل‌های JSON به صورت منظم بکاپ بگیرید
- **عملکرد**: برای تعداد زیاد کاربر از دیتابیس استفاده کنید
- **محدودیت‌ها**: محدودیت‌های API تلگرام را رعایت کنید

## 📞 پشتیبانی

در صورت وجود مشکل:
1. لاگ‌های PHP را بررسی کنید
2. فایل‌های JSON را چک کنید
3. دسترسی‌های فایل را تست کنید

## 📜 مجوز

این پروژه تحت مجوز MIT منتشر شده است.

---

**توسعه یافته توسط**: تیم توسعه
**نسخه**: 2.0.0
**آخرین بروزرسانی**: 2025
