# 🔄 راهنمای تنظیم حالت ربات (رایگان/اشتراکی)

## 📋 فهرست
1. [معرفی](#معرفی)
2. [حالت رایگان](#حالت-رایگان)
3. [حالت اشتراکی](#حالت-اشتراکی)
4. [تنظیمات پیشرفته](#تنظیمات-پیشرفته)
5. [سناریوهای مختلف](#سناریوهای-مختلف)

---

## 🎯 معرفی

ربات شما می‌تواند در دو حالت کار کند:

### 🆓 حالت رایگان:
- تمام قابلیت‌ها برای همه رایگان
- بدون نیاز به پرداخت
- مناسب برای شروع یا ربات‌های عمومی

### 💎 حالت اشتراکی:
- قابلیت‌های خاص نیاز به اشتراک دارند
- درآمدزایی از ربات
- دوره آزمایشی رایگان
- مناسب برای ربات‌های حرفه‌ای

---

## 🆓 حالت رایگان

### فعال کردن:

در فایل `config.php`:

```php
// Subscription Settings
define('SUBSCRIPTION_REQUIRED', false); // false = رایگان
```

### ویژگی‌ها:
- ✅ تمام قابلیت‌ها رایگان
- ✅ بدون محدودیت
- ✅ بدون نیاز به پرداخت
- ✅ مناسب برای شروع

### مناسب برای:
- ربات‌های شخصی
- ربات‌های آموزشی
- پروژه‌های تست
- ربات‌های عمومی

---

## 💎 حالت اشتراکی

### فعال کردن:

در فایل `config.php`:

```php
// Subscription Settings
define('SUBSCRIPTION_REQUIRED', true); // true = اشتراکی
define('FREE_TRIAL_DAYS', 7); // 7 روز آزمایشی رایگان
```

### ویژگی‌ها:
- ✅ درآمدزایی از ربات
- ✅ دوره آزمایشی رایگان
- ✅ کنترل دسترسی به قابلیت‌ها
- ✅ مدیریت اشتراک‌ها

### قبل از فعال کردن:

1. **تعریف پلن‌ها:**
```
/addplan یک ماهه|Monthly|30|50000
```

2. **تنظیم کارت:**
```
/setpayment 6037991234567890|علی احمدی|ملی
```

3. **تست سیستم:**
- خرید یک اشتراک تست
- تأیید رسید
- چک کردن فعال‌سازی

---

## ⚙️ تنظیمات پیشرفته

### 1. دوره آزمایشی

```php
define('FREE_TRIAL_DAYS', 7); // تعداد روز
```

**مقادیر:**
- `0` = بدون دوره آزمایشی
- `7` = 7 روز رایگان
- `30` = 1 ماه رایگان

**نکته:** دوره آزمایشی از زمان `/start` شروع می‌شود.

---

### 2. قابلیت‌های نیازمند اشتراک

```php
define('SUBSCRIPTION_FEATURES', [
    'ai_chat' => true,           // چت با AI
    'ai_advanced' => true,       // قابلیت‌های پیشرفته AI
    'group_management' => false, // مدیریت گروه (رایگان)
    'plugins' => true,           // پلاگین‌ها
    'broadcast' => true,         // ارسال همگانی
]);
```

**توضیح:**
- `true` = نیاز به اشتراک
- `false` = رایگان برای همه

---

## 🎨 سناریوهای مختلف

### سناریو 1: همه چیز رایگان
```php
define('SUBSCRIPTION_REQUIRED', false);
```

**نتیجه:** تمام قابلیت‌ها برای همه رایگان.

---

### سناریو 2: فقط AI اشتراکی
```php
define('SUBSCRIPTION_REQUIRED', true);
define('FREE_TRIAL_DAYS', 7);
define('SUBSCRIPTION_FEATURES', [
    'ai_chat' => true,           // نیاز به اشتراک
    'ai_advanced' => true,       // نیاز به اشتراک
    'group_management' => false, // رایگان
    'plugins' => false,          // رایگان
    'broadcast' => true,         // نیاز به اشتراک (فقط ادمین)
]);
```

**نتیجه:**
- ✅ مدیریت گروه: رایگان
- ✅ پلاگین‌ها: رایگان
- 💎 AI: نیاز به اشتراک
- 💎 ارسال همگانی: نیاز به اشتراک

---

### سناریو 3: همه چیز اشتراکی با 30 روز آزمایشی
```php
define('SUBSCRIPTION_REQUIRED', true);
define('FREE_TRIAL_DAYS', 30);
define('SUBSCRIPTION_FEATURES', [
    'ai_chat' => true,
    'ai_advanced' => true,
    'group_management' => true,  // حتی مدیریت گروه
    'plugins' => true,
    'broadcast' => true,
]);
```

**نتیجه:**
- 🎁 30 روز اول: همه چیز رایگان
- 💎 بعد از 30 روز: نیاز به اشتراک

---

### سناریو 4: بدون دوره آزمایشی
```php
define('SUBSCRIPTION_REQUIRED', true);
define('FREE_TRIAL_DAYS', 0); // بدون آزمایشی
```

**نتیجه:** از همان ابتدا نیاز به خرید اشتراک.

---

## 🔍 چک کردن دسترسی در کد

### روش 1: استفاده از AccessControl

```php
require_once 'AccessControl.php';
$access = AccessControl::getInstance();

// چک کردن دسترسی
if (!$access->hasAccess($userId, 'ai_chat')) {
    $telegram->sendMessage($chatId, "⚠️ نیاز به اشتراک!");
    return;
}

// ادامه کد...
```

### روش 2: استفاده از requireSubscription

```php
$access = AccessControl::getInstance();

// خودکار پیام می‌فرسته و false برمی‌گردونه
if (!$access->requireSubscription($userId, $chatId, 'ai_chat')) {
    return;
}

// ادامه کد...
```

### روش 3: دریافت وضعیت کامل

```php
$status = $access->getAccessStatus($userId);

if ($status['is_admin']) {
    echo "ادمین - دسترسی کامل";
} elseif ($status['has_subscription']) {
    echo "اشتراک فعال تا: {$status['subscription_end']}";
} elseif ($status['in_trial']) {
    echo "دوره آزمایشی: {$status['trial_days_left']} روز";
} else {
    echo "نیاز به اشتراک";
}
```

---

## 📊 مشاهده وضعیت

### برای کاربر:
```
/start - نمایش وضعیت اشتراک
/mysubscription - جزئیات اشتراک
```

### برای ادمین:
```
/bot_mode - مشاهده حالت ربات
/subscriptions - آمار اشتراک‌ها
```

---

## 🔄 تغییر حالت

### از پنل ادمین:
```
🎛 پنل مدیریت → 🔄 حالت ربات
```

### دستی:

1. فایل `config.php` را باز کنید
2. خط زیر را پیدا کنید:
```php
define('SUBSCRIPTION_REQUIRED', false);
```
3. مقدار را تغییر دهید:
```php
define('SUBSCRIPTION_REQUIRED', true); // یا false
```
4. ذخیره کنید

✅ تغییرات بلافاصله اعمال می‌شود!

---

## 💡 نکات مهم

### 1. ادمین‌ها:
```php
// ادمین‌ها همیشه دسترسی کامل دارند
if (in_array($userId, ADMIN_IDS)) {
    // دسترسی کامل
}
```

### 2. مدیریت گروه:
```php
// توصیه: مدیریت گروه رایگان باشد
'group_management' => false,
```

### 3. دوره آزمایشی:
- از زمان `/start` شروع می‌شود
- فقط یکبار برای هر کاربر
- بعد از اتمام، نیاز به اشتراک

### 4. تست:
```php
// برای تست، دوره آزمایشی را زیاد کنید
define('FREE_TRIAL_DAYS', 365); // 1 سال!
```

---

## 🎯 توصیه‌ها

### برای شروع:
```php
define('SUBSCRIPTION_REQUIRED', false); // رایگان
```
- ابتدا رایگان شروع کنید
- کاربر جمع کنید
- بعد اشتراکی کنید

### برای درآمدزایی:
```php
define('SUBSCRIPTION_REQUIRED', true);
define('FREE_TRIAL_DAYS', 7);
```
- 7 روز آزمایشی بدهید
- قابلیت‌های خاص را اشتراکی کنید
- مدیریت گروه را رایگان نگه دارید

### برای ربات حرفه‌ای:
```php
define('SUBSCRIPTION_REQUIRED', true);
define('FREE_TRIAL_DAYS', 3);
```
- دوره آزمایشی کوتاه
- قیمت مناسب
- پشتیبانی خوب

---

## 🐛 عیب‌یابی

### همه چیز رایگان شده!
```php
// چک کنید:
define('SUBSCRIPTION_REQUIRED', true); // باید true باشد
```

### دوره آزمایشی کار نمیکنه:
```php
// چک کنید:
define('FREE_TRIAL_DAYS', 7); // باید بیشتر از 0 باشد
```

### قابلیت خاص رایگان شده:
```php
// چک کنید:
'ai_chat' => true, // باید true باشد برای اشتراکی
```

---

## 📞 پشتیبانی

سوال دارید؟
- 📢 کانال: @YourChannel
- 💬 گروه: https://t.me/joinchat/XXXXX

---

**نسخه:** 2.0  
**تاریخ:** 1404/08/05  

