# 💎 راهنمای کامل سیستم اشتراک و پرداخت

## 📋 فهرست مطالب
1. [معرفی](#معرفی)
2. [نصب و راه‌اندازی](#نصب-و-راه‌اندازی)
3. [مدیریت پلن‌ها](#مدیریت-پلن‌ها)
4. [تنظیمات پرداخت](#تنظیمات-پرداخت)
5. [فرآیند خرید](#فرآیند-خرید)
6. [مدیریت رسیدها](#مدیریت-رسیدها)
7. [دستورات](#دستورات)

---

## 🎯 معرفی

سیستم اشتراک و پرداخت کامل با قابلیت‌های:

### ✨ ویژگی‌ها:
- ✅ **پلن‌های متنوع** - تعریف پلن‌های مختلف
- ✅ **پرداخت کارت به کارت** - پرداخت آسان
- ✅ **ارسال رسید** - آپلود عکس رسید
- ✅ **تأیید/رد خودکار** - توسط ادمین
- ✅ **فعال‌سازی خودکار** - بعد از تأیید
- ✅ **اعلان انقضا** - 3 روز قبل
- ✅ **آمار کامل** - درآمد و اشتراک‌ها
- ✅ **تاریخچه پرداخت** - برای کاربران

---

## 🚀 نصب و راه‌اندازی

### مرحله 1: فایل‌ها
تمام فایل‌های زیر باید موجود باشند:
```
bot-v2/
├── SubscriptionManager.php
├── handlers/SubscriptionHandler.php
└── cron/check_subscriptions.php
```

### مرحله 2: دیتابیس
جداول خودکار ساخته می‌شوند:
- `subscription_plans` - پلن‌ها
- `user_subscriptions` - اشتراک کاربران
- `payment_receipts` - رسیدهای پرداخت
- `payment_settings` - تنظیمات کارت

### مرحله 3: Cron Job
برای چک کردن اشتراک‌های منقضی شده:

```bash
# هر 1 ساعت
0 * * * * php /path/to/bot-v2/cron/check_subscriptions.php
```

---

## 📦 مدیریت پلن‌ها

### افزودن پلن جدید

#### از پنل ادمین:
```
/addplan نام|نام_انگلیسی|مدت|قیمت
```

**مثال:**
```
/addplan یک ماهه|Monthly|30|50000
```

#### از کد:
```php
$subManager = SubscriptionManager::getInstance();

$subManager->createPlan([
    'name' => 'یک ماهه',
    'name_en' => 'Monthly',
    'duration_days' => 30,
    'price' => 50000,
    'features' => [
        'دسترسی کامل به AI',
        'پشتیبانی 24/7',
        'بدون محدودیت'
    ]
]);
```

### ویرایش پلن

```php
$subManager->updatePlan($planId, [
    'price' => 45000,
    'is_active' => true
]);
```

### حذف پلن

```php
$subManager->deletePlan($planId);
```

### مشاهده پلن‌ها

**کاربر:**
```
/subscribe
```

**ادمین:**
```
/plans
```

---

## 💳 تنظیمات پرداخت

### تنظیم شماره کارت

#### از پنل ادمین:
```
/setpayment شماره_کارت|نام_صاحب_کارت|نام_بانک
```

**مثال:**
```
/setpayment 6037991234567890|علی احمدی|ملی
```

#### از کد:
```php
$subManager->updatePaymentSettings([
    'card_number' => '6037991234567890',
    'card_holder' => 'علی احمدی',
    'bank_name' => 'ملی'
]);
```

### مشاهده تنظیمات

**ادمین:**
```
/payment_settings
```

**کاربر:**
```
/payment
```

---

## 🛒 فرآیند خرید (برای کاربر)

### مرحله 1: انتخاب پلن
```
/subscribe
```
سپس پلن مورد نظر را انتخاب کنید.

### مرحله 2: مشاهده اطلاعات پرداخت
اطلاعات کارت نمایش داده می‌شود:
```
💳 اطلاعات پرداخت

شماره کارت: 6037-9912-3456-7890
به نام: علی احمدی
بانک: ملی
```

### مرحله 3: واریز وجه
مبلغ را به شماره کارت واریز کنید.

### مرحله 4: ارسال رسید
عکس رسید واریزی را ارسال کنید.

### مرحله 5: انتظار تأیید
```
✅ رسید شما با موفقیت ثبت شد!
🔢 شماره پیگیری: 123

⏳ رسید شما در حال بررسی است.
```

### مرحله 6: فعال‌سازی
بعد از تأیید ادمین:
```
✅ رسید شما تأیید شد!
🎉 اشتراک شما فعال شد.
```

---

## 🧾 مدیریت رسیدها (برای ادمین)

### مشاهده رسیدهای در انتظار

```
/receipts
```

یا از پنل:
```
🎛 پنل مدیریت → 🧾 رسیدها
```

### تأیید رسید

1. روی دکمه **✅ تأیید** کلیک کنید
2. اشتراک خودکار فعال می‌شود
3. کاربر اعلان دریافت می‌کند

**از کد:**
```php
$subManager->approveReceipt($receiptId, $adminId, 'تأیید شد');
```

### رد رسید

1. روی دکمه **❌ رد** کلیک کنید
2. کاربر اعلان دریافت می‌کند

**از کد:**
```php
$subManager->rejectReceipt($receiptId, $adminId, 'مبلغ اشتباه است');
```

### مشاهده رسید

روی دکمه **👁 مشاهده رسید** کلیک کنید.

---

## 📊 آمار و گزارش

### آمار کلی

```
/subscriptions
```

نمایش:
- ✅ اشتراک‌های فعال
- ⏳ رسیدهای در انتظار
- ⚠️ منقضی شونده (7 روز)
- 💰 درآمد کل

### از کد:

```php
$stats = $subManager->getStats();

echo "فعال: {$stats['active']}\n";
echo "در انتظار: {$stats['pending']}\n";
echo "درآمد: {$stats['revenue']} تومان\n";
```

---

## 🔍 بررسی اشتراک کاربر

### چک کردن اشتراک فعال

```php
$subManager = SubscriptionManager::getInstance();

if ($subManager->hasActiveSubscription($userId)) {
    echo "کاربر اشتراک فعال دارد";
} else {
    echo "کاربر اشتراک ندارد";
}
```

### دریافت اطلاعات اشتراک

```php
$subscription = $subManager->getUserSubscription($userId);

if ($subscription) {
    echo "پلن: {$subscription['name']}\n";
    echo "تاریخ انقضا: {$subscription['end_date']}\n";
}
```

### محدود کردن دسترسی

```php
// در هر handler
if (!$subManager->hasActiveSubscription($userId)) {
    $telegram->sendMessage(
        $chatId,
        "⚠️ برای استفاده از این قابلیت نیاز به اشتراک دارید!\n\n" .
        "برای خرید: /subscribe"
    );
    return;
}

// ادامه کد...
```

---

## 📱 دستورات کاربر

| دستور | توضیح |
|-------|-------|
| `/subscribe` | مشاهده و خرید پلن‌ها |
| `/mysubscription` | اشتراک من |
| `/payment` | اطلاعات پرداخت |

---

## 🔧 دستورات ادمین

| دستور | توضیح |
|-------|-------|
| `/subscriptions` | آمار اشتراک‌ها |
| `/receipts` | رسیدهای در انتظار |
| `/plans` | مدیریت پلن‌ها |
| `/payment_settings` | تنظیمات پرداخت |
| `/addplan` | افزودن پلن جدید |
| `/setpayment` | تنظیم کارت |

---

## 🎨 سفارشی‌سازی

### تغییر متن پیام‌ها

در `handlers/SubscriptionHandler.php`:

```php
// پیام خوشامد
$message = "💎 به بخش اشتراک خوش آمدید!";

// پیام تأیید
$message = "✅ پرداخت شما تأیید شد!";
```

### افزودن فیلد به پلن

```php
$subManager->createPlan([
    'name' => 'ویژه',
    'name_en' => 'Premium',
    'duration_days' => 90,
    'price' => 120000,
    'features' => [
        'دسترسی کامل',
        'پشتیبانی اختصاصی',
        'بدون تبلیغات',
        'ویژگی جدید شما'  // اضافه کردن
    ]
]);
```

### تغییر مدت اعلان انقضا

در `cron/check_subscriptions.php`:

```php
// از 3 روز به 7 روز
AND us.end_date BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 7 DAY)
```

---

## 🔐 امنیت

### نکات مهم:

1. ✅ **شماره کارت را محرمانه نگه دارید**
2. ✅ **رسیدها را دقیق بررسی کنید**
3. ✅ **از Photoshop شده بودن رسید مطمئن شوید**
4. ✅ **مبلغ را با پلن مطابقت دهید**
5. ✅ **تاریخ رسید را چک کنید**

### جلوگیری از تقلب:

```php
// چک کردن تاریخ رسید
$receiptDate = /* از OCR یا دستی */;
$now = time();

if (($now - $receiptDate) > 86400) { // 24 ساعت
    // رسید قدیمی است
    $subManager->rejectReceipt($receiptId, $adminId, 'رسید قدیمی است');
}
```

---

## 📈 گزارش‌گیری

### گزارش روزانه

```php
$today = date('Y-m-d');

$dailyRevenue = $db->query(
    "SELECT SUM(amount) as total 
     FROM payment_receipts 
     WHERE status = 'approved' 
     AND DATE(reviewed_at) = '{$today}'"
)->fetch_assoc()['total'];

echo "درآمد امروز: " . number_format($dailyRevenue) . " تومان";
```

### گزارش ماهانه

```php
$month = date('Y-m');

$monthlyRevenue = $db->query(
    "SELECT SUM(amount) as total 
     FROM payment_receipts 
     WHERE status = 'approved' 
     AND DATE_FORMAT(reviewed_at, '%Y-%m') = '{$month}'"
)->fetch_assoc()['total'];

echo "درآمد این ماه: " . number_format($monthlyRevenue) . " تومان";
```

---

## 🐛 عیب‌یابی

### رسید ارسال نمیشه:
1. سایز عکس را کاهش دهید (کمتر از 5MB)
2. فرمت عکس JPG یا PNG باشد
3. اتصال اینترنت کاربر را چک کنید

### اشتراک فعال نمیشه:
1. وضعیت رسید را چک کنید (pending/approved)
2. لاگ `subscription_errors_*.log` را ببینید
3. جدول `user_subscriptions` را چک کنید

### اعلان انقضا ارسال نمیشه:
1. Cron job را چک کنید
2. فیلد `notified_expiry` را NULL کنید
3. لاگ cron را ببینید

---

## 💡 نکات و ترفندها

### 1. تخفیف ویژه:
```php
// 20% تخفیف برای خرید 3 ماهه
if ($planId == 3) { // پلن 3 ماهه
    $discount = $plan['price'] * 0.2;
    $finalPrice = $plan['price'] - $discount;
}
```

### 2. کد تخفیف:
```php
// جدول discount_codes
if ($discountCode) {
    $code = $db->fetchOne(
        "SELECT * FROM discount_codes WHERE code = ? AND is_active = 1",
        [$discountCode]
    );
    
    if ($code) {
        $discount = $plan['price'] * ($code['percent'] / 100);
        $finalPrice = $plan['price'] - $discount;
    }
}
```

### 3. اشتراک رایگان آزمایشی:
```php
// 7 روز رایگان
$subManager->createPlan([
    'name' => 'آزمایشی',
    'name_en' => 'Trial',
    'duration_days' => 7,
    'price' => 0,
    'features' => ['دسترسی محدود']
]);
```

---

## 📞 پشتیبانی

سوال دارید؟
- 📢 کانال: @YourChannel
- 💬 گروه: https://t.me/joinchat/XXXXX

---

**نسخه:** 2.0  
**تاریخ:** 1404/08/05  
**توسعه‌دهنده:** Kiro AI Assistant
