<?php
/**
 * English Language File
 */

return [
    'welcome' => [
        'title' => '🤖 Welcome to Group Management Bot!',
        'message' => "Hello :name!\n\nTo use the bot, add it to your group.",
        'add_to_group' => 'Add to Group',
        'help' => 'Help',
        'support' => 'Support',
    ],
    
    'commands' => [
        'start' => 'Start',
        'help' => 'Help',
        'panel' => 'Panel',
        'settings' => 'Settings',
        'stats' => 'Statistics',
        'ban' => 'Ban',
        'unban' => 'Unban',
        'kick' => 'Kick',
        'warn' => 'Warn',
        'mute' => 'Mute',
        'unmute' => 'Unmute',
    ],
    
    'messages' => [
        'bot_installed' => '✅ Bot installed successfully!',
        'bot_already_installed' => '⚠️ Bot is already installed!',
        'user_banned' => '🚫 User :name has been banned!',
        'user_unbanned' => '✅ User :name has been unbanned!',
        'user_kicked' => '👢 User :name has been kicked!',
        'user_warned' => '⚠️ User :name received a warning! (:count/:max)',
        'user_muted' => '🔇 User :name has been muted!',
        'user_unmuted' => '🔊 User :name has been unmuted!',
        'no_permission' => '❌ You don\'t have permission!',
        'invalid_user' => '❌ Invalid user!',
        'error_occurred' => '❌ An error occurred! Please try again.',
    ],
    
    'stats' => [
        'title' => '📊 Statistics',
        'total_users' => 'Total Users',
        'total_groups' => 'Total Groups',
        'today_users' => 'Today\'s Users',
        'today_groups' => 'Today\'s Groups',
        'active_users' => 'Active Users',
    ],
    
    'panel' => [
        'title' => '🎛 Management Panel',
        'locks' => '🔒 Locks',
        'lists' => '📋 Lists',
        'settings' => '⚙️ Settings',
        'stats' => '📊 Statistics',
        'close' => '❌ Close',
    ],
    
    'locks' => [
        'link' => 'Link',
        'forward' => 'Forward',
        'tag' => 'Tag',
        'hashtag' => 'Hashtag',
        'photo' => 'Photo',
        'video' => 'Video',
        'voice' => 'Voice',
        'sticker' => 'Sticker',
        'enabled' => '✅ Enabled',
        'disabled' => '❌ Disabled',
    ],
    
    'ai' => [
        'thinking' => '🤔 Thinking...',
        'error' => '❌ Sorry, I couldn\'t respond. Please try again.',
        'no_api_key' => '⚠️ API Key is not configured!',
        'rate_limit' => '⏳ Please wait a moment and try again.',
    ],
    
    'language' => [
        'current' => 'Current language: English 🇬🇧',
        'select' => 'Please select your language:',
        'changed' => '✅ Language changed successfully!',
        'fa' => '🇮🇷 فارسی',
        'en' => '🇬🇧 English',
        'ar' => '🇸🇦 العربية',
        'tr' => '🇹🇷 Türkçe',
    ],
    
    'plugins' => [
        'enabled' => '✅ Plugin :name enabled!',
        'disabled' => '❌ Plugin :name disabled!',
        'not_found' => '⚠️ Plugin :name not found!',
        'list' => '📦 Plugins List',
        'no_plugins' => 'No plugins installed.',
    ],
];
