<?php
/**
 * Welcome Plugin - Example Plugin
 * Sends welcome message to new members
 */

declare(strict_types=1);

class WelcomePlugin extends BasePlugin {
    protected string $name = 'Welcome';
    protected string $version = '1.0.0';
    protected string $description = 'Sends welcome messages to new members';
    protected string $author = 'Kiro AI';
    
    /**
     * Called when plugin is enabled
     */
    public function onEnable(): void {
        // Initialize plugin
        $this->log('Welcome Plugin enabled');
    }
    
    /**
     * Called when plugin is disabled
     */
    public function onDisable(): void {
        $this->log('Welcome Plugin disabled');
    }
    
    /**
     * Called when new member joins
     */
    public function onNewMember(array $data): void {
        $chatId = $data['chat_id'] ?? null;
        $userId = $data['user_id'] ?? null;
        $firstName = $data['first_name'] ?? 'کاربر';
        
        if (!$chatId || !$userId) {
            return;
        }
        
        // Get custom welcome message from config
        $config = $this->getConfig();
        $message = $config['message'] ?? "سلام {name} عزیز! 🎉\nبه گروه ما خوش آمدید!";
        
        // Replace variables
        $message = str_replace(
            ['{name}', '{id}'],
            [$firstName, $userId],
            $message
        );
        
        // Send welcome message
        $this->telegram->sendMessage($chatId, $message);
        
        $this->log("Welcome message sent to user {$userId} in chat {$chatId}");
    }
    
    /**
     * Log plugin activity
     */
    private function log(string $message): void {
        $logFile = LOGS_PATH . '/plugins_' . date('Y-m-d') . '.log';
        $timestamp = date('Y-m-d H:i:s');
        file_put_contents($logFile, "[{$timestamp}] [Welcome] {$message}\n", FILE_APPEND);
    }
}
