# 📝 تغییرات آپلود گروهی و Spoiler

## تاریخ: 2025-10-19

---

## ✅ مشکلات برطرف شده:

### 1️⃣ **مشکل چند لینک برای media group**

**قبل:**
```
کاربر 3 ویدیو میفرستاد → 3 لینک جدا دریافت میکرد ❌
```

**بعد:**
```
کاربر 3 ویدیو میفرستاد → 1 لینک برای همه دریافت میکنه ✅
```

**چطور حل شد:**
- حذف شرط `$is_new` که باعث ایجاد چند لینک میشد
- فقط استفاده از `was_group_link_sent()` برای چک کردن
- اضافه کردن `sleep(2)` برای اطمینان از دریافت همه فایل‌ها قبل از ارسال لینک
- نمایش تعداد فایل‌ها در پیام لینک

**کد اصلاح شده (index.php خط ~286-304):**
```php
if ($media_group_id) {
    // Media group - چند فایل همزمان
    list($upload_id, $is_new) = get_or_create_upload_for_group($user_id, $media_group_id);
    add_upload_item($upload_id, [
        'type' => $found_media,
        'file_id' => $file_id,
        'caption' => $caption,
        'has_spoiler' => $has_spoiler
    ]);
    // فقط یک بار لینک رو بفرستیم
    if (!was_group_link_sent($user_id, $media_group_id)) {
        sleep(2); // تاخیر برای دریافت همه فایل‌ها
        $protect_link = "https://t.me/" . BOT_USERNAME . "?start=" . $upload_id;
        $upload_data = get_upload($upload_id);
        $file_count = count($upload_data['items'] ?? []);
        send_message($chat_id, "📁 لینک آپلود شما آماده شد!\n📦 تعداد فایل: $file_count\n\n" . $protect_link);
        mark_group_link_sent($user_id, $media_group_id);
    }
}
```

---

### 2️⃣ **پشتیبانی از Spoiler**

**چیست:** وقتی ویدیو یا عکس با spoiler فرستاده بشه (محتوای blur شده)، حالا حفظ میشه!

**قابلیت:**
- ✅ تشخیص خودکار `has_media_spoiler` از پیام
- ✅ ذخیره در دیتابیس آپلود
- ✅ ارسال با spoiler به کاربر

**فایل‌های تغییر یافته:**

**index.php (خط ~273):**
```php
$has_spoiler = $message['has_media_spoiler'] ?? false;
```

**functions.php (تابع send_media_by_type):**
```php
function send_media_by_type($chat_id, $type, $file_id, $caption = null, $has_spoiler = false) {
    // ...
    if ($has_spoiler && in_array($type, ['photo', 'video'])) {
        $data['has_spoiler'] = true;
    }
    // ...
}
```

---

### 3️⃣ **پیام اطلاع حذف خودکار**

**چیست:** وقتی فایل فرستاده میشه، یه پیام به کاربر میگه که فایل‌ها چند وقت دیگه حذف میشن.

**مثال:**
```
⚠️ فایل(ها) بعد از 2 دقیقه حذف خواهند شد.
```

**کد اضافه شده (functions.php خط ~1221-1226):**
```php
if ($file_delete_after > 0) {
    $minutes = floor($file_delete_after / 60);
    $seconds = $file_delete_after % 60;
    $time_display = $minutes > 0 ? "$minutes دقیقه و $seconds ثانیه" : "$seconds ثانیه";
    send_message($chat_id, "⚠️ فایل(ها) بعد از <b>$time_display</b> حذف خواهند شد.");
}
```

---

## 📋 ساختار داده آپلود (uploads.json):

```json
{
  "up_abc123": {
    "id": "up_abc123",
    "user_id": 123456789,
    "created_at": "2025-10-19 14:30:00",
    "items": [
      {
        "type": "video",
        "file_id": "BAACAgQAAxkBAAI...",
        "caption": "ویدیو اول",
        "has_spoiler": true
      },
      {
        "type": "video",
        "file_id": "BAACAgQAAxkBAAI...",
        "caption": "ویدیو دوم",
        "has_spoiler": false
      },
      {
        "type": "video",
        "file_id": "BAACAgQAAxkBAAI...",
        "caption": null,
        "has_spoiler": true
      }
    ]
  }
}
```

---

## 🔄 جریان کار media group:

```
1. کاربر 3 ویدیو میفرسته
   ↓
2. ربات media_group_id تشخیص میده
   ↓
3. upload_id مشترک ساخته میشه (یا موجود استفاده میشه)
   ↓
4. هر فایل با has_spoiler ذخیره میشه
   ↓
5. بعد از دریافت آخرین فایل (sleep 2s)
   ↓
6. یک لینک با تعداد فایل‌ها فرستاده میشه
   ↓
7. لینک mark میشه تا دوباره فرستاده نشه
```

---

## 🎯 تست کنید:

### ✅ تست 1: آپلود گروهی عادی
```
- 3 ویدیو بدون spoiler بفرستید
- باید یک لینک با "تعداد فایل: 3" بگیرید
```

### ✅ تست 2: آپلود گروهی با spoiler
```
- 3 ویدیو با spoiler بفرستید
- باید یک لینک بگیرید
- وقتی لینک رو باز میکنید، ویدیوها باید blur باشند
```

### ✅ تست 3: آپلود تکی با spoiler
```
- یک عکس با spoiler بفرستید
- باید یک لینک بگیرید
- عکس باید blur نمایش داده بشه
```

### ✅ تست 4: پیام حذف خودکار
```
- تنظیمات → حذف خودکار فایل‌ها → 2 دقیقه
- یک فایل آپلود کنید و لینک رو باز کنید
- باید پیام "فایل(ها) بعد از 2 دقیقه حذف خواهند شد" رو ببینید
```

---

## 📁 فایل‌های تغییر یافته:

| فایل | تغییرات |
|------|---------|
| `index.php` | اصلاح media group + اضافه spoiler |
| `functions.php` | اصلاح send_media_by_type + پیام حذف |

---

## 🐛 اگر هنوز مشکل دارید:

### مشکل: هنوز چند لینک میاد
**راه حل:**
1. فایل `media_groups.json` رو پاک کنید
2. دوباره تست کنید

### مشکل: spoiler کار نمیکنه
**راه حل:**
- مطمئن بشید که از تلگرام آپدیت استفاده میکنید
- spoiler فقط برای photo و video کار میکنه

---

**همه چیز آماده است!** 🚀
